/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSelectFilesDialog
extends DialogWrapper {
    private final String myPrompt;

    public AbstractSelectFilesDialog(Project project, boolean canBeParent, @Nullable VcsShowConfirmationOption confirmationOption, @Nullable String prompt) {
        super(project, canBeParent);
        this.myPrompt = prompt;
        if (confirmationOption != null) {
            this.setDoNotAskOption((DialogWrapper.DoNotAskOption)new MyDoNotAskOption(confirmationOption));
        }
    }

    @NotNull
    protected abstract ChangesTree getFileList();

    protected JComponent createNorthPanel() {
        if (this.myPrompt != null) {
            JLabel label = new JLabel(this.myPrompt);
            label.setUI((LabelUI)new MultiLineLabelUI());
            label.setBorder((Border)JBUI.Borders.empty((int)5, (int)1));
            return label;
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getFileList();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        DefaultActionGroup group = this.createToolbarActions();
        group.add((AnAction)Separator.getInstance());
        group.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("VcsSelectFilesDialog", (ActionGroup)group, true);
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(toolbar, this.getFileList());
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)toolbarPanel, "North");
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.getFileList())), "Center");
        return panel2;
    }

    @NotNull
    protected DefaultActionGroup createToolbarActions() {
        return new DefaultActionGroup();
    }

    private static class MyDoNotAskOption
    extends DialogWrapper.DoNotAskOption.Adapter {
        private final VcsShowConfirmationOption myConfirmationOption;

        private MyDoNotAskOption(@NotNull VcsShowConfirmationOption confirmationOption) {
            this.myConfirmationOption = confirmationOption;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        public void rememberChoice(boolean isSelected, int exitCode) {
            if (isSelected) {
                if (exitCode == 0) {
                    this.myConfirmationOption.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
                }
                if (exitCode == 1) {
                    this.myConfirmationOption.setValue(VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY);
                }
            }
        }
    }
}

