/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ShowRecentlyDeletedShelvesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        if (project == null || project.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(!ShelveChangesManager.getInstance(project).getDeletedLists().isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ShelvedChangesViewManager.getInstance(project).activateView(Collections.min(ShelveChangesManager.getInstance(project).getDeletedLists(), ShelvedChangesViewManager.ChangelistComparator.getInstance()));
    }
}

