/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelfDeleteNotification;
import com.intellij.openapi.vcs.changes.shelf.ShelfNotification;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangesViewManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ShelvedChangesViewManager.class);
    @NonNls
    static final String SHELF_CONTEXT_MENU = "Vcs.Shelf.ContextMenu";
    private static final String SHELVE_PREVIEW_SPLITTER_PROPORTION = "ShelvedChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    private final ShelveChangesManager myShelveChangesManager;
    private final Project myProject;
    private ShelfToolWindowPanel myPanel = null;
    private ContentImpl myContent = null;
    private final MergingUpdateQueue myUpdateQueue;
    private final List<Runnable> myPostUpdateEdtActivity = new ArrayList<Runnable>();
    public static final DataKey<ChangesTree> SHELVED_CHANGES_TREE = DataKey.create((String)"ShelveChangesManager.ShelvedChangesTree");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_RECYCLED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedRecycledChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_DELETED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedDeletedChangeListData");
    public static final DataKey<List<ShelvedChange>> SHELVED_CHANGE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChange");
    public static final DataKey<List<ShelvedBinaryFile>> SHELVED_BINARY_FILE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedBinaryFile");

    public static ShelvedChangesViewManager getInstance(Project project) {
        return (ShelvedChangesViewManager)project.getService(ShelvedChangesViewManager.class);
    }

    public ShelvedChangesViewManager(Project project) {
        this.myProject = project;
        this.myShelveChangesManager = ShelveChangesManager.getInstance(project);
        this.myUpdateQueue = new MergingUpdateQueue("Update Shelf Content", 200, true, null, (Disposable)this.myProject, null, true);
        project.getMessageBus().connect().subscribe(ShelveChangesManager.SHELF_TOPIC, e -> this.scheduleContentUpdate());
    }

    private void scheduleContentUpdate() {
        this.myUpdateQueue.queue((Update)new MyContentUpdater());
    }

    private void updateTreeIfShown(@NotNull Consumer<? super ShelfTree> treeConsumer) {
        if (this.myContent == null) {
            return;
        }
        treeConsumer.consume((Object)this.myPanel.myTree);
    }

    void updateViewContent() {
        if (this.myShelveChangesManager.getAllLists().isEmpty()) {
            if (this.myContent != null) {
                this.removeContent((Content)this.myContent);
                VcsNotifier.getInstance(this.myProject).hideAllNotificationsByType(ShelfNotification.class);
            }
            this.myContent = null;
        } else {
            if (this.myContent == null) {
                this.myPanel = new ShelfToolWindowPanel(this.myProject);
                this.myContent = new ContentImpl((JComponent)this.myPanel.myRootPanel, VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]), false);
                this.myContent.setTabName("Shelf");
                MyDnDTarget dnDTarget = new MyDnDTarget(this.myPanel.myProject, (Content)this.myContent);
                this.myContent.putUserData(Content.TAB_DND_TARGET_KEY, (Object)dnDTarget);
                this.myContent.setCloseable(false);
                this.myContent.setDisposer((Disposable)this.myPanel);
                DnDSupport.createBuilder((JComponent)((Object)this.myPanel.myTree)).setImageProvider(x$0 -> this.myPanel.createDraggedImage(x$0)).setBeanProvider(x$0 -> this.myPanel.createDragStartBean(x$0)).setTargetChecker((DnDTargetChecker)dnDTarget).setDropHandler((DnDDropHandler)dnDTarget).setDisposableParent((Disposable)this.myContent).install();
                this.addContent((Content)this.myContent);
            }
            this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.rebuildTree()));
        }
    }

    protected void removeContent(Content content2) {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.removeContent(content2);
        contentManager.selectContent("Local Changes");
    }

    protected void addContent(Content content2) {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.addContent(content2);
    }

    protected void activateContent() {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.setSelectedContent((Content)this.myContent);
        ToolWindow window = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
        if (window != null && !window.isVisible()) {
            window.activate(null);
        }
    }

    private void updateTreeModel() {
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.setPaintBusy(true)));
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> {
            List<ShelvedChangeList> lists = this.myShelveChangesManager.getAllLists();
            lists.forEach(l -> l.loadChangesIfNeeded(this.myProject));
            List sortedLists = ContainerUtil.sorted(lists, (Comparator)ChangelistComparator.getInstance());
            ApplicationManager.getApplication().invokeLater(() -> {
                this.updateViewContent();
                this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> {
                    tree.setLoadedLists(sortedLists);
                    tree.setPaintBusy(false);
                    tree.rebuildTree();
                }));
                this.myPostUpdateEdtActivity.forEach(Runnable::run);
                this.myPostUpdateEdtActivity.clear();
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        });
    }

    public void startEditing(@NotNull ShelvedChangeList shelvedChangeList) {
        this.runAfterUpdate(() -> {
            this.selectShelvedList(shelvedChangeList);
            this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.startEditingAtPath(tree.getLeadSelectionPath())));
        });
    }

    public void activateView(@Nullable ShelvedChangeList list) {
        this.runAfterUpdate(() -> {
            if (this.myContent == null) {
                return;
            }
            if (list != null) {
                this.selectShelvedList(list);
            }
            this.activateContent();
        });
    }

    private void runAfterUpdate(@NotNull Runnable postUpdateRunnable) {
        GuiUtils.invokeLaterIfNeeded(() -> {
            this.myUpdateQueue.cancelAllUpdates();
            this.myPostUpdateEdtActivity.add(postUpdateRunnable);
            this.updateTreeModel();
        }, (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    public void closeEditorPreview() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContent == null) {
            return;
        }
        DiffPreview diffPreview = this.myPanel.myDiffPreview;
        if (diffPreview instanceof EditorTabPreview) {
            ((EditorTabPreview)diffPreview).closePreview();
        }
    }

    public void openEditorPreview() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContent == null) {
            return;
        }
        this.myPanel.openEditorPreview();
    }

    public void updateOnVcsMappingsChanged() {
        ApplicationManager.getApplication().invokeLater(() -> this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> {
            ChangesGroupingSupport treeGroupingSupport = tree.getGroupingSupport();
            if (treeGroupingSupport.isAvailable("repository") && treeGroupingSupport.get("repository")) {
                tree.rebuildTree();
            }
        })), this.myProject.getDisposed());
    }

    public void selectShelvedList(@NotNull ShelvedChangeList list) {
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> {
            DefaultMutableTreeNode treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)tree.getModel().getRoot()), (Object)list);
            if (treeNode == null) {
                LOG.warn(VcsBundle.message((String)"shelve.changelist.not.found", (Object[])new Object[]{list.DESCRIPTION}));
                return;
            }
            TreeUtil.selectNode((JTree)((Object)tree), (TreeNode)treeNode);
        }));
    }

    @NotNull
    private static Set<ShelvedChangeList> getSelectedLists(@NotNull ChangesTree tree, @NotNull Predicate<? super ShelvedChangeList> condition) {
        Object[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return Collections.emptySet();
        }
        return (Set)((StreamEx)((StreamEx)StreamEx.of((Object[])selectionPaths).map(path2 -> (ShelvedChangeList)TreeUtil.findObjectInPath((TreePath)path2, ShelvedChangeList.class)).filter(Objects::nonNull)).filter(condition)).collect(Collectors.toSet());
    }

    @NotNull
    static ListSelection<ShelvedWrapper> getSelectedChangesOrAll(@NotNull DataContext dataContext) {
        List<ShelvedWrapper> allWrappers;
        ChangesBrowserNode changeListNode;
        ShelvedChangeList changeList;
        ChangesTree tree = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE));
        if (tree == null) {
            return ListSelection.createAt(Collections.emptyList(), (int)0);
        }
        ListSelection wrappers = ListSelection.createAt(VcsTreeModelData.selected((JTree)((Object)tree)).userObjects(ShelvedWrapper.class), (int)0);
        if (wrappers.getList().size() == 1 && (changeList = (ShelvedChangeList)ContainerUtil.getFirstItem(ShelvedChangesViewManager.getSelectedLists(tree, it -> true))) != null && (changeListNode = (ChangesBrowserNode)TreeUtil.findNodeWithObject(tree.getRoot(), (Object)changeList)) != null && (allWrappers = changeListNode.getAllObjectsUnder(ShelvedWrapper.class)).size() > 1) {
            ShelvedWrapper toSelect = (ShelvedWrapper)ContainerUtil.getFirstItem((List)wrappers.getList());
            return ListSelection.create(allWrappers, (Object)toSelect);
        }
        return wrappers;
    }

    @NotNull
    public static List<ShelvedChangeList> getShelvedLists(@NotNull DataContext dataContext) {
        ArrayList<ShelvedChangeList> shelvedChangeLists = new ArrayList<ShelvedChangeList>();
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_CHANGELIST_KEY.getData(dataContext))));
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_RECYCLED_CHANGELIST_KEY.getData(dataContext))));
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_DELETED_CHANGELIST_KEY.getData(dataContext))));
        return shelvedChangeLists;
    }

    @NotNull
    public static List<ShelvedChangeList> getExactlySelectedLists(@NotNull DataContext dataContext) {
        ChangesTree shelvedChangeTree = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE));
        if (shelvedChangeTree == null) {
            return ContainerUtil.emptyList();
        }
        return StreamEx.of(VcsTreeModelData.exactlySelected((JTree)((Object)shelvedChangeTree)).userObjectsStream(ShelvedChangeList.class)).toList();
    }

    @NotNull
    public static List<ShelvedChange> getShelveChanges(@NotNull DataContext dataContext) {
        return ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_CHANGE_KEY)));
    }

    @NotNull
    public static List<ShelvedBinaryFile> getBinaryShelveChanges(@NotNull DataContext dataContext) {
        return ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_BINARY_FILE_KEY)));
    }

    @NotNull
    public static List<String> getSelectedShelvedChangeNames(@NotNull DataContext dataContext) {
        ChangesTree shelvedChangeTree = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE));
        if (shelvedChangeTree == null) {
            return ContainerUtil.emptyList();
        }
        return StreamEx.of(VcsTreeModelData.selected((JTree)((Object)shelvedChangeTree)).userObjectsStream(ShelvedWrapper.class)).map(ShelvedWrapper::getPath).toList();
    }

    public static class PostStartupActivity
    implements StartupActivity.Background {
        public void runActivity(@NotNull Project project) {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            ShelvedChangesViewManager.getInstance(project).scheduleContentUpdate();
        }
    }

    private class MyContentUpdater
    extends Update {
        MyContentUpdater() {
            super((Object)"ShelfContentUpdate");
        }

        public void run() {
            ShelvedChangesViewManager.this.updateTreeModel();
        }

        public boolean canEat(Update update) {
            return true;
        }
    }

    private static class ShelvedChangeNode
    extends ChangesBrowserNode<ShelvedWrapper>
    implements Comparable<ShelvedChangeNode> {
        @NotNull
        private final ShelvedWrapper myShelvedChange;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        private final String myAdditionalText;

        protected ShelvedChangeNode(@NotNull ShelvedWrapper shelvedChange, @NotNull FilePath filePath, @Nullable String additionalText) {
            super(shelvedChange);
            this.myShelvedChange = shelvedChange;
            this.myFilePath = filePath;
            this.myAdditionalText = additionalText;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
            String path2 = this.myShelvedChange.getRequestName();
            String directory = StringUtil.defaultIfEmpty((String)PathUtil.getParentPath((String)path2), (String)VcsBundle.message((String)"shelve.default.path.rendering", (Object[])new Object[0]));
            String fileName = StringUtil.defaultIfEmpty((String)PathUtil.getFileName((String)path2), (String)path2);
            renderer.append(fileName, new SimpleTextAttributes(0, this.myShelvedChange.getFileStatus().getColor()));
            if (this.myAdditionalText != null) {
                renderer.append(FontUtil.spaceAndThinSpace() + this.myAdditionalText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (renderer.isShowFlatten()) {
                renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.toSystemDependentName((String)directory), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            renderer.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon());
        }

        @Override
        public String getTextPresentation() {
            return PathUtil.getFileName((String)this.myShelvedChange.getRequestName());
        }

        @Override
        protected boolean isFile() {
            return true;
        }

        @Override
        public int compareTo(@NotNull ShelvedChangeNode o) {
            return ShelvedChangeNode.compareFilePaths(this.myFilePath, o.myFilePath);
        }

        @Override
        @Nullable
        public Color getBackgroundColor(@NotNull Project project) {
            return ShelvedChangeNode.getBackgroundColorFor(project, this.myFilePath);
        }
    }

    private static class ShelvedListNode
    extends ChangesBrowserNode<ShelvedChangeList> {
        private static final Icon PatchIcon = PatchFileType.INSTANCE.getIcon();
        private static final Icon AppliedPatchIcon = new IconUtil.IconSizeWrapper(AllIcons.Vcs.Patch_applied, AllIcons.Vcs.Patch_applied.getIconWidth(), AllIcons.Vcs.Patch_applied.getIconHeight()){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.6f);
                super.paintIcon(c, g, x, y);
            }
        };
        private static final Icon DisabledToDeleteIcon = IconUtil.desaturate((Icon)AllIcons.Actions.GC);
        @NotNull
        private final ShelvedChangeList myList;

        ShelvedListNode(@NotNull ShelvedChangeList list) {
            super(list);
            this.myList = list;
        }

        @NotNull
        public ShelvedChangeList getList() {
            return this.myList;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
            if (this.myList.isRecycled() || this.myList.isDeleted()) {
                renderer.appendTextWithIssueLinks(this.myList.DESCRIPTION, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                renderer.setIcon(this.myList.isMarkedToDelete() || this.myList.isDeleted() ? DisabledToDeleteIcon : AppliedPatchIcon);
            } else {
                renderer.appendTextWithIssueLinks(this.myList.DESCRIPTION, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer.setIcon(PatchIcon);
            }
            this.appendCount(renderer);
            String date = DateFormatUtil.formatPrettyDateTime((Date)this.myList.DATE);
            renderer.append(", " + date, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private static class MyShelvedPreviewProcessor
    extends CacheDiffRequestProcessor<ShelvedWrapper>
    implements DiffPreviewUpdateProcessor {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelfTree myTree;
        @NotNull
        private final DiffShelvedChangesActionProvider.PatchesPreloader myPreloader;
        @Nullable
        private ShelvedWrapper myCurrentShelvedElement;

        MyShelvedPreviewProcessor(@NotNull Project project, @NotNull ShelfTree tree) {
            super(project);
            this.myProject = project;
            this.myTree = tree;
            this.myPreloader = new DiffShelvedChangesActionProvider.PatchesPreloader(project);
        }

        @NotNull
        protected String getRequestName(@NotNull ShelvedWrapper provider) {
            return provider.getRequestName();
        }

        protected ShelvedWrapper getCurrentRequestProvider() {
            return this.myCurrentShelvedElement;
        }

        @Override
        public void clear() {
            if (this.myCurrentShelvedElement != null) {
                this.myCurrentShelvedElement = null;
                this.updateRequest();
            }
            this.dropCaches();
        }

        @Override
        public void refresh(boolean fromModelRefresh) {
            DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
            List<ShelvedChange> selectedChanges = ShelvedChangesViewManager.getShelveChanges(dc);
            List<ShelvedBinaryFile> selectedBinaryChanges = ShelvedChangesViewManager.getBinaryShelveChanges(dc);
            if (selectedChanges.isEmpty() && selectedBinaryChanges.isEmpty()) {
                this.clear();
                return;
            }
            if (this.myCurrentShelvedElement != null && (this.keepBinarySelection(selectedBinaryChanges, this.myCurrentShelvedElement.getBinaryFile()) || this.keepShelvedSelection(selectedChanges, this.myCurrentShelvedElement.getShelvedChange()))) {
                this.dropCachesIfNeededAndUpdate(this.myCurrentShelvedElement);
                return;
            }
            this.myCurrentShelvedElement = !selectedChanges.isEmpty() ? new ShelvedWrapper(selectedChanges.get(0)) : new ShelvedWrapper(selectedBinaryChanges.get(0));
            this.dropCachesIfNeededAndUpdate(this.myCurrentShelvedElement);
        }

        private void dropCachesIfNeededAndUpdate(@NotNull ShelvedWrapper currentShelvedElement) {
            boolean dropCaches;
            ShelvedChange shelvedChange = currentShelvedElement.getShelvedChange();
            boolean bl = dropCaches = shelvedChange != null && this.myPreloader.isPatchFileChanged(shelvedChange.getPatchPath());
            if (dropCaches) {
                this.dropCaches();
            }
            this.updateRequest(dropCaches);
        }

        boolean keepShelvedSelection(@NotNull List<ShelvedChange> selectedChanges, @Nullable ShelvedChange currentShelvedChange) {
            return currentShelvedChange != null && selectedChanges.contains(currentShelvedChange);
        }

        boolean keepBinarySelection(@NotNull List<ShelvedBinaryFile> selectedBinaryChanges, @Nullable ShelvedBinaryFile currentBinary) {
            return currentBinary != null && selectedBinaryChanges.contains(currentBinary);
        }

        @NotNull
        protected DiffRequest loadRequest(@NotNull ShelvedWrapper provider, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
            try {
                ShelvedChange shelvedChange = provider.getShelvedChange();
                if (shelvedChange != null) {
                    return new PatchDiffRequest(DiffShelvedChangesActionProvider.createAppliedTextPatch(this.myPreloader.getPatch(shelvedChange, null)));
                }
                DiffContentFactoryEx factory = DiffContentFactoryEx.getInstanceEx();
                ShelvedBinaryFile binaryFile = Objects.requireNonNull(provider.getBinaryFile());
                if (binaryFile.AFTER_PATH == null) {
                    throw new DiffRequestProducerException("Content for '" + this.getRequestName(provider) + "' was removed");
                }
                byte[] binaryContent = binaryFile.createBinaryContentRevision(this.myProject).getBinaryContent();
                FileType fileType = VcsUtil.getFilePath((String)binaryFile.SHELVED_PATH).getFileType();
                return new SimpleDiffRequest(this.getRequestName(provider), (DiffContent)factory.createEmpty(), factory.createBinary(this.myProject, binaryContent, fileType, this.getRequestName(provider)), null, null);
            }
            catch (VcsException | IOException e) {
                throw new DiffRequestProducerException("Can't show diff for '" + this.getRequestName(provider) + "'", e);
            }
        }
    }

    private static final class ShelfToolWindowPanel
    implements ChangesViewContentManagerListener,
    Disposable {
        @NotNull
        private static final RegistryValue isEditorDiffPreview = Registry.get((String)"show.diff.preview.as.editor.tab");
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        private final Project myProject;
        private final ShelveChangesManager myShelveChangesManager;
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final JScrollPane myTreeScrollPane;
        private final ShelfTree myTree;
        private final ActionToolbar myToolbar;
        @NotNull
        private final JPanel myRootPanel = new JPanel(new BorderLayout());
        private MyShelvedPreviewProcessor myChangeProcessor;
        private DiffPreview myDiffPreview;

        private ShelfToolWindowPanel(@NotNull Project project) {
            this.myProject = project;
            this.myShelveChangesManager = ShelveChangesManager.getInstance(this.myProject);
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            this.myTree = new ShelfTree(this.myProject);
            this.myTree.setEditable(true);
            this.myTree.setDragEnabled(!ApplicationManager.getApplication().isHeadlessEnvironment());
            this.myTree.getGroupingSupport().setGroupingKeysOrSkip(this.myShelveChangesManager.getGrouping());
            this.myTree.addGroupingChangeListener(e -> {
                this.myShelveChangesManager.setGrouping(this.myTree.getGroupingSupport().getGroupingKeys());
                this.myTree.rebuildTree();
            });
            DefaultTreeCellEditor treeCellEditor = new DefaultTreeCellEditor((JTree)((Object)this.myTree), null){

                @Override
                public boolean isCellEditable(EventObject event) {
                    return !(event instanceof MouseEvent) && super.isCellEditable(event);
                }
            };
            this.myTree.setCellEditor(treeCellEditor);
            treeCellEditor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)myTree.getLastSelectedPathComponent();
                    if (node instanceof ShelvedListNode && e.getSource() instanceof TreeCellEditor) {
                        String editorValue = ((TreeCellEditor)e.getSource()).getCellEditorValue().toString();
                        ShelvedChangeList shelvedChangeList = ((ShelvedListNode)node).getList();
                        myShelveChangesManager.renameChangeList(shelvedChangeList, editorValue);
                    }
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                }
            });
            AnAction showDiffAction = ActionManager.getInstance().getAction("Diff.ShowDiff");
            showDiffAction.registerCustomShortcutSet(showDiffAction.getShortcutSet(), (JComponent)((Object)this.myTree));
            EditSourceAction editSourceAction = new EditSourceAction();
            editSourceAction.registerCustomShortcutSet(editSourceAction.getShortcutSet(), (JComponent)((Object)this.myTree));
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            actionGroup.addAll((ActionGroup)ActionManager.getInstance().getAction("ShelvedChangesToolbar"));
            actionGroup.add((AnAction)new MyToggleDetailsAction(), new Constraints(Anchor.AFTER, "ShelvedChanges.ShowHideDeleted"));
            this.myToolbar = ActionManager.getInstance().createActionToolbar("ShelvedChanges", (ActionGroup)actionGroup, false);
            this.myTreeScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1);
            this.myRootPanel.add((Component)this.myTreeScrollPane, "Center");
            this.addToolbar(ChangesViewContentManagerKt.isCommitToolWindow(this.myProject));
            this.setDiffPreview();
            isEditorDiffPreview.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    this.setDiffPreview();
                }
            }, (Disposable)this);
            isOpenEditorDiffPreviewWithSingleClick.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (!this.isSplitterPreview()) {
                        this.setDiffPreview(true);
                    }
                }
            }, (Disposable)this);
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)this);
            DataManager.registerDataProvider((JComponent)this.myRootPanel, (DataProvider)this.myTree);
            PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)"ShelvedChangesPopupMenu", (String)ShelvedChangesViewManager.SHELF_CONTEXT_MENU);
        }

        public void dispose() {
        }

        @Override
        public void toolWindowMappingChanged() {
            this.addToolbar(ChangesViewContentManagerKt.isCommitToolWindow(this.myProject));
            this.setDiffPreview();
        }

        private void addToolbar(boolean isHorizontal) {
            if (isHorizontal) {
                this.myToolbar.setOrientation(0);
                this.myRootPanel.add((Component)this.myToolbar.getComponent(), "North");
            } else {
                this.myToolbar.setOrientation(1);
                this.myRootPanel.add((Component)this.myToolbar.getComponent(), "West");
            }
        }

        private void setDiffPreview() {
            this.setDiffPreview(false);
        }

        private void setDiffPreview(boolean force) {
            boolean isEditorPreview;
            boolean bl = isEditorPreview = ChangesViewContentManagerKt.isCommitToolWindow(this.myProject) || isEditorDiffPreview.asBoolean();
            if (!force) {
                if (isEditorPreview && this.myDiffPreview instanceof EditorTabPreview) {
                    return;
                }
                if (!isEditorPreview && this.isSplitterPreview()) {
                    return;
                }
            }
            if (this.myChangeProcessor != null) {
                Disposer.dispose((Disposable)this.myChangeProcessor);
            }
            this.myChangeProcessor = new MyShelvedPreviewProcessor(this.myProject, this.myTree);
            Disposer.register((Disposable)this, (Disposable)this.myChangeProcessor);
            this.myDiffPreview = isEditorPreview ? this.installEditorPreview(this.myChangeProcessor) : this.installSplitterPreview(this.myChangeProcessor);
        }

        @NotNull
        private EditorTabPreview installEditorPreview(final @NotNull MyShelvedPreviewProcessor changeProcessor) {
            EditorTabPreview editorPreview = new EditorTabPreview((DiffRequestProcessor)changeProcessor){

                @Override
                protected String getCurrentName() {
                    ShelvedWrapper myCurrentShelvedElement = changeProcessor.myCurrentShelvedElement;
                    return myCurrentShelvedElement != null ? myCurrentShelvedElement.getRequestName() : VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]);
                }

                @Override
                protected boolean hasContent() {
                    return changeProcessor.myCurrentShelvedElement != null;
                }

                @Override
                protected boolean skipPreviewUpdate() {
                    if (super.skipPreviewUpdate()) {
                        return true;
                    }
                    if (!((Object)((Object)myTree)).equals(IdeFocusManager.getInstance((Project)myProject).getFocusOwner())) {
                        return true;
                    }
                    return !this.isEditorPreviewAllowed();
                }
            };
            editorPreview.setEscapeHandler(() -> {
                editorPreview.closePreview();
                ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
                if (toolWindow != null) {
                    toolWindow.activate(null);
                }
            });
            if (isOpenEditorDiffPreviewWithSingleClick.asBoolean()) {
                editorPreview.openWithSingleClick(this.myTree);
            } else {
                editorPreview.openWithDoubleClick(this.myTree);
            }
            editorPreview.installNextDiffActionOn(this.myTreeScrollPane);
            return editorPreview;
        }

        @NotNull
        private PreviewDiffSplitterComponent installSplitterPreview(@NotNull MyShelvedPreviewProcessor changeProcessor) {
            PreviewDiffSplitterComponent previewSplitter = new PreviewDiffSplitterComponent(changeProcessor, ShelvedChangesViewManager.SHELVE_PREVIEW_SPLITTER_PROPORTION);
            previewSplitter.setFirstComponent(this.myTreeScrollPane);
            previewSplitter.setPreviewVisible(this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN);
            this.myTree.addSelectionListener(() -> previewSplitter.updatePreview(false), (Disposable)changeProcessor);
            this.myRootPanel.add((Component)((Object)previewSplitter), "Center");
            Disposer.register((Disposable)changeProcessor, () -> {
                this.myRootPanel.remove((Component)((Object)previewSplitter));
                this.myRootPanel.add((Component)this.myTreeScrollPane, "Center");
                this.myRootPanel.revalidate();
                this.myRootPanel.repaint();
            });
            return previewSplitter;
        }

        private boolean isSplitterPreview() {
            return this.myDiffPreview instanceof PreviewDiffSplitterComponent;
        }

        private boolean isEditorPreviewAllowed() {
            return !isOpenEditorDiffPreviewWithSingleClick.asBoolean() || this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
        }

        private void openEditorPreview() {
            if (this.isSplitterPreview()) {
                return;
            }
            if (!this.isEditorPreviewAllowed()) {
                return;
            }
            ((EditorTabPreview)this.myDiffPreview).openPreview(false);
        }

        @Nullable
        private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
            if (info.isMove()) {
                DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
                return new DnDDragStartBean((Object)new ShelvedChangeListDragBean(ShelvedChangesViewManager.getShelveChanges(dc), ShelvedChangesViewManager.getBinaryShelveChanges(dc), ShelvedChangesViewManager.getShelvedLists(dc)));
            }
            return null;
        }

        @NotNull
        private DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
            String imageText = VcsBundle.message((String)"unshelve.changes.action", (Object[])new Object[0]);
            Image image = (Image)DnDAwareTree.getDragImage((Tree)this.myTree, (String)imageText, null).getFirst();
            return new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
        }

        private class MyToggleDetailsAction
        extends ShowDiffPreviewAction {
            private MyToggleDetailsAction() {
            }

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabledAndVisible(ShelfToolWindowPanel.this.isSplitterPreview() || isOpenEditorDiffPreviewWithSingleClick.asBoolean());
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                ShelfToolWindowPanel.this.myDiffPreview.setPreviewVisible(state);
                ((ShelfToolWindowPanel)ShelfToolWindowPanel.this).myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN = state;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                return ((ShelfToolWindowPanel)ShelfToolWindowPanel.this).myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
            }
        }
    }

    private static final class MyDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyDnDTarget(@NotNull Project project, @NotNull Content content2) {
            super(project, content2);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ChangeListDragBean) {
                FileDocumentManager.getInstance().saveAllDocuments();
                List<Change> changes = Arrays.asList(((ChangeListDragBean)attachedObject).getChanges());
                ShelveChangesManager.getInstance(this.myProject).shelveSilentlyUnderProgress(changes);
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject = event.getAttachedObject();
            return attachedObject instanceof ChangeListDragBean && ((ChangeListDragBean)attachedObject).getChanges().length > 0;
        }
    }

    private static class MyShelveDeleteProvider
    implements DeleteProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelfTree myTree;

        private MyShelveDeleteProvider(@NotNull Project project, @NotNull ShelfTree tree) {
            this.myProject = project;
            this.myTree = tree;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            List shelvedListsToDelete = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this.myTree), ShelvedChangeList.class);
            List<ShelvedChange> changesToDelete = MyShelveDeleteProvider.getChangesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getShelveChanges(dataContext));
            List<ShelvedBinaryFile> binariesToDelete = MyShelveDeleteProvider.getBinariesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext));
            ShelveChangesManager manager = ShelveChangesManager.getInstance(this.myProject);
            int fileListSize = binariesToDelete.size() + changesToDelete.size();
            Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDates = manager.deleteShelves(shelvedListsToDelete, ShelvedChangesViewManager.getShelvedLists(dataContext), changesToDelete, binariesToDelete);
            if (!createdDeletedListsWithOriginalDates.isEmpty()) {
                this.showUndoDeleteNotification(shelvedListsToDelete, fileListSize, createdDeletedListsWithOriginalDates);
            }
        }

        private void showUndoDeleteNotification(@NotNull List<? extends ShelvedChangeList> shelvedListsToDelete, int fileListSize, @NotNull Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDate) {
            String message = MyShelveDeleteProvider.constructDeleteSuccessfullyMessage(fileListSize, shelvedListsToDelete.size(), (ShelvedChangeList)ContainerUtil.getFirstItem(shelvedListsToDelete));
            ShelfDeleteNotification shelfDeletionNotification = new ShelfDeleteNotification(message);
            shelfDeletionNotification.addAction((AnAction)new UndoShelfDeletionAction(this.myProject, createdDeletedListsWithOriginalDate));
            shelfDeletionNotification.addAction(ActionManager.getInstance().getAction("ShelvedChanges.ShowRecentlyDeleted"));
            VcsNotifier.getInstance(this.myProject).showNotificationAndHideExisting(shelfDeletionNotification, ShelfDeleteNotification.class);
        }

        private static List<ShelvedBinaryFile> getBinariesNotInLists(@NotNull List<? extends ShelvedChangeList> listsToDelete, @NotNull List<? extends ShelvedBinaryFile> binaryFiles) {
            ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>(binaryFiles);
            for (ShelvedChangeList shelvedChangeList : listsToDelete) {
                result2.removeAll(shelvedChangeList.getBinaryFiles());
            }
            return result2;
        }

        @NotNull
        private static List<ShelvedChange> getChangesNotInLists(@NotNull List<? extends ShelvedChangeList> listsToDelete, @NotNull List<? extends ShelvedChange> shelvedChanges) {
            ArrayList<ShelvedChange> result2 = new ArrayList<ShelvedChange>(shelvedChanges);
            listsToDelete.stream().map(list -> Objects.requireNonNull(list.getChanges())).forEach(result2::removeAll);
            return result2;
        }

        @NotNull
        private static String constructDeleteSuccessfullyMessage(int fileNum, int listNum, @Nullable ShelvedChangeList first) {
            String filesMessage;
            String string = filesMessage = fileNum != 0 ? VcsBundle.message((String)"shelve.delete.files.successful.message", (Object[])new Object[]{fileNum}) : "";
            String changelistsMessage = listNum != 0 ? VcsBundle.message((String)"shelve.delete.changelists.message", (Object[])new Object[]{listNum, listNum == 1 && first != null ? first.DESCRIPTION : ""}) : "";
            return StringUtil.capitalize((String)VcsBundle.message((String)"shelve.delete.successful.message", (Object[])new Object[]{filesMessage, fileNum > 0 && listNum > 0 ? 1 : 0, changelistsMessage}));
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            return !ShelvedChangesViewManager.getShelvedLists(dataContext).isEmpty();
        }

        private static class UndoShelfDeletionAction
        extends NotificationAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final Map<ShelvedChangeList, Date> myListDateMap;

            private UndoShelfDeletionAction(@NotNull Project project, @NotNull Map<ShelvedChangeList, Date> listDateMap) {
                super(IdeBundle.messagePointer((String)"undo.dialog.title", (Object[])new Object[0]));
                this.myProject = project;
                this.myListDateMap = listDateMap;
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                ShelveChangesManager manager = ShelveChangesManager.getInstance(this.myProject);
                List cantRestoreList = ContainerUtil.findAll(this.myListDateMap.keySet(), l -> !manager.getDeletedLists().contains(l));
                this.myListDateMap.forEach((l, d) -> manager.restoreList((ShelvedChangeList)l, (Date)d));
                notification.expire();
                if (!cantRestoreList.isEmpty()) {
                    VcsNotifier.getInstance(this.myProject).notifyMinorWarning(VcsBundle.message((String)"shelve.undo.deletion", (Object[])new Object[0]), VcsBundle.message((String)"shelve.changes.restore.error", (Object[])new Object[]{cantRestoreList.size()}));
                }
            }
        }
    }

    private static class ShelfTree
    extends ChangesTree {
        private List<ShelvedChangeList> myLoadedLists = ContainerUtil.emptyList();
        private final DeleteProvider myDeleteProvider = new MyShelveDeleteProvider(this.myProject, this);

        private ShelfTree(@NotNull Project project) {
            super(project, false, false, true);
            this.setKeepTreeState(true);
            this.setDoubleClickHandler((Processor<MouseEvent>)((Processor)e -> this.showShelvedChangesDiff()));
            this.setEnterKeyHandler((Processor<KeyEvent>)((Processor)e -> this.showShelvedChangesDiff()));
        }

        public void setLoadedLists(@NotNull List<ShelvedChangeList> lists) {
            this.myLoadedLists = new ArrayList<ShelvedChangeList>(lists);
        }

        public boolean isPathEditable(TreePath path2) {
            return this.isEditable() && this.getSelectionCount() == 1 && path2.getLastPathComponent() instanceof ShelvedListNode;
        }

        @Override
        @NotNull
        protected ChangesGroupingSupport installGroupingSupport() {
            return new ChangesGroupingSupport(this.myProject, (Object)this, false);
        }

        @Override
        public int getToggleClickCount() {
            return 2;
        }

        private boolean showShelvedChangesDiff() {
            if (!this.hasExactlySelectedChanges()) {
                return false;
            }
            DiffShelvedChangesActionProvider.showShelvedChangesDiff(DataManager.getInstance().getDataContext((Component)((Object)this)));
            return true;
        }

        private boolean hasExactlySelectedChanges() {
            return !UtilKt.isEmpty(VcsTreeModelData.exactlySelected((JTree)((Object)this)).userObjectsStream(ShelvedWrapper.class));
        }

        @Override
        public void rebuildTree() {
            boolean showRecycled = ShelveChangesManager.getInstance(this.myProject).isShowRecycled();
            MyShelvedTreeModelBuilder modelBuilder = new MyShelvedTreeModelBuilder(this.myProject, this.getGrouping());
            modelBuilder.setShelvedLists(ContainerUtil.filter(this.myLoadedLists, l -> !l.isDeleted() && (showRecycled || !l.isRecycled())));
            modelBuilder.setDeletedShelvedLists(ContainerUtil.filter(this.myLoadedLists, ShelvedChangeList::isDeleted));
            this.updateTreeModel(modelBuilder.build());
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (SHELVED_CHANGES_TREE.is(dataId)) {
                return this;
            }
            if (SHELVED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList(ShelvedChangesViewManager.getSelectedLists(this, l -> !l.isRecycled() && !l.isDeleted()));
            }
            if (SHELVED_RECYCLED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList(ShelvedChangesViewManager.getSelectedLists(this, l -> l.isRecycled() && !l.isDeleted()));
            }
            if (SHELVED_DELETED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList(ShelvedChangesViewManager.getSelectedLists(this, l -> l.isDeleted()));
            }
            if (SHELVED_CHANGE_KEY.is(dataId)) {
                return StreamEx.of(VcsTreeModelData.selected((JTree)((Object)this)).userObjectsStream(ShelvedWrapper.class)).map(s -> s.getShelvedChange()).nonNull().toList();
            }
            if (SHELVED_BINARY_FILE_KEY.is(dataId)) {
                return StreamEx.of(VcsTreeModelData.selected((JTree)((Object)this)).userObjectsStream(ShelvedWrapper.class)).map(s -> s.getBinaryFile()).nonNull().toList();
            }
            if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
                return this.getSelectionCount() > 0;
            }
            if (VcsDataKeys.CHANGES.is(dataId)) {
                List<ShelvedWrapper> shelvedChanges = VcsTreeModelData.selected((JTree)((Object)this)).userObjects(ShelvedWrapper.class);
                if (!shelvedChanges.isEmpty()) {
                    return ContainerUtil.map2Array(shelvedChanges, Change.class, s -> s.getChange(this.myProject));
                }
            } else {
                if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                    return this.myDeleteProvider;
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    List<ShelvedWrapper> shelvedChanges = VcsTreeModelData.selected((JTree)((Object)this)).userObjects(ShelvedWrapper.class);
                    ArrayDeque<1> navigatables = new ArrayDeque<1>();
                    for (final ShelvedWrapper shelvedChange : shelvedChanges) {
                        if (shelvedChange.getBeforePath() == null || FileStatus.ADDED.equals(shelvedChange.getFileStatus())) continue;
                        NavigatableAdapter navigatable = new NavigatableAdapter(){

                            public void navigate(boolean requestFocus) {
                                VirtualFile vf = shelvedChange.getBeforeVFUnderProject(myProject);
                                if (vf != null) {
                                    1.navigate((Project)myProject, (VirtualFile)vf, (boolean)true);
                                }
                            }
                        };
                        navigatables.add(navigatable);
                    }
                    return navigatables.toArray(new Navigatable[0]);
                }
            }
            return super.getData(dataId);
        }
    }

    static class ChangelistComparator
    implements Comparator<ShelvedChangeList> {
        private static final ChangelistComparator ourInstance = new ChangelistComparator();

        ChangelistComparator() {
        }

        public static ChangelistComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(ShelvedChangeList o1, ShelvedChangeList o2) {
            return o2.DATE.compareTo(o1.DATE);
        }
    }

    private static class MyShelvedTreeModelBuilder
    extends TreeModelBuilder {
        private MyShelvedTreeModelBuilder(Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
            super(project, grouping2);
        }

        public void setShelvedLists(@NotNull List<? extends ShelvedChangeList> shelvedLists) {
            this.createShelvedListsWithChangesNode(shelvedLists, this.myRoot);
        }

        public void setDeletedShelvedLists(@NotNull List<? extends ShelvedChangeList> shelvedLists) {
            this.createShelvedListsWithChangesNode(shelvedLists, this.createTagNode(VcsBundle.message((String)"shelve.recently.deleted.node", (Object[])new Object[0])));
        }

        private void createShelvedListsWithChangesNode(@NotNull List<? extends ShelvedChangeList> shelvedLists, @NotNull ChangesBrowserNode<?> parentNode) {
            shelvedLists.forEach(changeList -> {
                ArrayList<ShelvedWrapper> shelvedChanges = new ArrayList<ShelvedWrapper>();
                Objects.requireNonNull(changeList.getChanges()).stream().map(ShelvedWrapper::new).forEach(shelvedChanges::add);
                changeList.getBinaryFiles().stream().map(ShelvedWrapper::new).forEach(shelvedChanges::add);
                shelvedChanges.sort(Comparator.comparing(s -> s.getChange(this.myProject), CHANGE_COMPARATOR));
                ShelvedListNode shelvedListNode = new ShelvedListNode((ShelvedChangeList)changeList);
                this.insertSubtreeRoot(shelvedListNode, parentNode);
                for (ShelvedWrapper shelved : shelvedChanges) {
                    Change change = shelved.getChange(this.myProject);
                    FilePath filePath = ChangesUtil.getFilePath((Change)change);
                    this.insertChangeNode(change, shelvedListNode, new ShelvedChangeNode(shelved, filePath, change.getOriginText(this.myProject)));
                }
            });
        }
    }
}

