/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.util.WaitForProgressToShow;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesCommitExecutor
extends LocalCommitExecutor {
    private static final Logger LOG = Logger.getInstance(ShelveChangesCommitExecutor.class);
    private final Project myProject;

    public ShelveChangesCommitExecutor(Project project) {
        this.myProject = project;
    }

    @NotNull
    @Nls
    public String getActionText() {
        return VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]);
    }

    @NotNull
    public CommitSession createCommitSession(@NotNull CommitContext commitContext) {
        return new ShelveChangesCommitSession();
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.shelve";
    }

    public boolean supportsPartialCommit() {
        return true;
    }

    private class ShelveChangesCommitSession
    implements CommitSession {
        private ShelveChangesCommitSession() {
        }

        public boolean canExecute(Collection<Change> changes, String commitMessage2) {
            return changes.size() > 0;
        }

        public void execute(@NotNull Collection<Change> changes, @Nullable String commitMessage2) {
            if (changes.size() > 0 && !ChangesUtil.hasFileChanges(changes)) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message((String)"shelve.changes.only.directories", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0])), null, (Project)ShelveChangesCommitExecutor.this.myProject);
                return;
            }
            try {
                ShelvedChangeList list = ShelveChangesManager.getInstance(ShelveChangesCommitExecutor.this.myProject).shelveChanges(changes, commitMessage2, true, false, true);
                ShelvedChangesViewManager.getInstance(ShelveChangesCommitExecutor.this.myProject).activateView(list);
                Change[] changesArray = changes.toArray(new Change[0]);
                LocalChangeList changeList = ChangesUtil.getChangeListIfOnlyOne((Project)ShelveChangesCommitExecutor.this.myProject, (Change[])changesArray);
                if (changeList != null) {
                    ChangeListManager.getInstance((Project)ShelveChangesCommitExecutor.this.myProject).scheduleAutomaticEmptyChangeListDeletion(changeList, true);
                }
            }
            catch (Exception ex) {
                LOG.info((Throwable)ex);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{ex.getMessage()}), (String)CommonBundle.getErrorTitle()), (ModalityState)ModalityState.NON_MODAL, (Project)ShelveChangesCommitExecutor.this.myProject);
            }
        }

        public String getHelpId() {
            return null;
        }
    }
}

