/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchViewer;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyPatchChange {
    @NotNull
    private final ApplyPatchViewer myViewer;
    private final int myIndex;
    @NotNull
    private final LineRange myPatchDeletionRange;
    @NotNull
    private final LineRange myPatchInsertionRange;
    @NotNull
    private final AppliedTextPatch.HunkStatus myStatus;
    @Nullable
    private final List<DiffFragment> myPatchInnerDifferences;
    @NotNull
    private final List<DiffGutterOperation> myOperations = new ArrayList<DiffGutterOperation>();
    @NotNull
    private final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    private boolean myResolved;

    ApplyPatchChange(@NotNull PatchChangeBuilder.Hunk hunk, int index, @NotNull ApplyPatchViewer viewer) {
        this.myIndex = index;
        this.myViewer = viewer;
        this.myPatchDeletionRange = hunk.getPatchDeletionRange();
        this.myPatchInsertionRange = hunk.getPatchInsertionRange();
        this.myStatus = hunk.getStatus();
        DocumentEx patchDocument = viewer.getPatchEditor().getDocument();
        this.myPatchInnerDifferences = PatchChangeBuilder.computeInnerDifferences((Document)patchDocument, hunk);
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.myViewer.repaintDivider();
    }

    private void installHighlighters() {
        this.createResultHighlighters();
        this.createPatchHighlighters();
        this.createStatusHighlighter();
        this.createOperations();
    }

    private void createPatchHighlighters() {
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters((Editor)patchEditor, (LineRange)this.myPatchDeletionRange, (LineRange)this.myPatchInsertionRange, this.myPatchInnerDifferences));
    }

    private void createResultHighlighters() {
        LineRange resultRange = this.getResultRange();
        if (resultRange == null) {
            return;
        }
        EditorEx editor = this.myViewer.getResultEditor();
        int startLine = resultRange.start;
        int endLine = resultRange.end;
        TextDiffType type = this.getDiffType();
        boolean resolved = this.isRangeApplied();
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)editor, startLine, endLine, type).withResolved(resolved).done());
    }

    private void createStatusHighlighter() {
        int line1 = this.myPatchDeletionRange.start;
        int line2 = this.myPatchInsertionRange.end;
        Color color = this.getStatusColor();
        if (this.isResolved()) {
            color = ColorUtil.mix((Color)color, (Color)this.myViewer.getPatchEditor().getGutterComponentEx().getBackground(), (double)0.6f);
        }
        String tooltip = this.getStatusText();
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        DocumentEx document = patchEditor.getDocument();
        MarkupModelEx markupModel = patchEditor.getMarkupModel();
        TextRange textRange = DiffUtil.getLinesRange((Document)document, (int)line1, (int)line2);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(null, textRange.getStartOffset(), textRange.getEndOffset(), 6000, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyGutterRenderer(line1, line2, color, tooltip));
        this.myHighlighters.add(highlighter);
    }

    private void destroyHighlighters() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public AppliedTextPatch.HunkStatus getStatus() {
        return this.myStatus;
    }

    @NotNull
    public LineRange getPatchRange() {
        return new LineRange(this.myPatchDeletionRange.start, this.myPatchInsertionRange.end);
    }

    @NotNull
    public LineRange getPatchAffectedRange() {
        return this.isRangeApplied() ? this.myPatchInsertionRange : this.myPatchDeletionRange;
    }

    @NotNull
    public LineRange getPatchDeletionRange() {
        return this.myPatchDeletionRange;
    }

    @NotNull
    public LineRange getPatchInsertionRange() {
        return this.myPatchInsertionRange;
    }

    @Nullable
    public LineRange getResultRange() {
        ApplyPatchViewer.MyModel model = this.myViewer.getModel();
        int lineStart = model.getLineStart(this.myIndex);
        int lineEnd = model.getLineEnd(this.myIndex);
        if (lineStart != -1 || lineEnd != -1) {
            return new LineRange(lineStart, lineEnd);
        }
        return null;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    @NotNull
    public TextDiffType getDiffType() {
        return DiffUtil.getDiffType((!this.myPatchDeletionRange.isEmpty() ? 1 : 0) != 0, (!this.myPatchInsertionRange.isEmpty() ? 1 : 0) != 0);
    }

    public boolean isRangeApplied() {
        return this.myResolved || this.getStatus() == AppliedTextPatch.HunkStatus.ALREADY_APPLIED;
    }

    @NotNull
    private String getStatusText() {
        switch (this.myStatus) {
            case ALREADY_APPLIED: {
                return VcsBundle.message((String)"patch.apply.already.applied.status", (Object[])new Object[0]);
            }
            case EXACTLY_APPLIED: {
                return VcsBundle.message((String)"patch.apply.automatically.applied.status", (Object[])new Object[0]);
            }
            case NOT_APPLIED: {
                return VcsBundle.message((String)"patch.apply.not.applied.status", (Object[])new Object[0]);
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    private Color getStatusColor() {
        switch (this.myStatus) {
            case ALREADY_APPLIED: {
                return JBColor.YELLOW.darker();
            }
            case EXACTLY_APPLIED: {
                return new JBColor(new Color(0, 180, 5), new Color(0, 147, 5));
            }
            case NOT_APPLIED: {
                return JBColor.RED.darker();
            }
        }
        throw new IllegalStateException();
    }

    private void createOperations() {
        if (this.myViewer.isReadOnly()) {
            return;
        }
        if (this.isResolved()) {
            return;
        }
        if (this.myStatus == AppliedTextPatch.HunkStatus.EXACTLY_APPLIED) {
            ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.APPLY));
        }
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.IGNORE));
    }

    @Nullable
    private DiffGutterOperation createOperation(@NotNull OperationType type) {
        if (this.isResolved()) {
            return null;
        }
        EditorEx editor = this.myViewer.getPatchEditor();
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, (int)this.getPatchRange().start);
        return new DiffGutterOperation.Simple((Editor)editor, offset, () -> {
            if (type == OperationType.APPLY) {
                return this.createApplyRenderer();
            }
            return this.createIgnoreRenderer();
        });
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]), DiffUtil.getArrowIcon((Side)Side.RIGHT), () -> this.myViewer.executeCommand(DiffBundle.message((String)"merge.dialog.accept.change.command", (Object[])new Object[0]), () -> this.myViewer.replaceChange(this)));
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]), AllIcons.Diff.Remove, () -> this.myViewer.executeCommand(DiffBundle.message((String)"merge.dialog.ignore.change.command", (Object[])new Object[0]), () -> this.myViewer.markChangeResolved(this)));
    }

    @Nullable
    private static GutterIconRenderer createIconRenderer(@NotNull String text2, @NotNull Icon icon2, final @NotNull Runnable perform) {
        String tooltipText = DiffUtil.createTooltipText((String)text2, null);
        return new DiffGutterRenderer(icon2, tooltipText){

            protected void handleMouseClick() {
                perform.run();
            }
        };
    }

    @NotNull
    public State storeState() {
        LineRange resultRange = this.getResultRange();
        return new State(this.myIndex, resultRange != null ? resultRange.start : -1, resultRange != null ? resultRange.end : -1, this.myResolved);
    }

    public void restoreState(@NotNull State state) {
        this.myResolved = state.myResolved;
    }

    private class MyGutterRenderer
    implements ActiveGutterRenderer {
        private final int myLine1;
        private final int myLine2;
        private final Color myColor;
        private final String myTooltip;

        MyGutterRenderer(int line1, int line2, Color color, String tooltip) {
            this.myLine1 = line1;
            this.myLine2 = line2;
            this.myColor = color;
            this.myTooltip = tooltip;
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            LineStatusMarkerRenderer.paintSimpleRange((Graphics)g, (Editor)editor, (int)this.myLine1, (int)this.myLine2, (Color)this.myColor);
        }

        public String getTooltipText() {
            return this.myTooltip;
        }

        public boolean canDoAction(@NotNull MouseEvent e) {
            return LineStatusMarkerRenderer.isInsideMarkerArea((MouseEvent)e);
        }

        public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
            if (ApplyPatchChange.this.getResultRange() != null) {
                ApplyPatchChange.this.myViewer.scrollToChange(ApplyPatchChange.this, Side.RIGHT, false);
            }
        }

        @NotNull
        public String getAccessibleName() {
            return VcsBundle.message((String)"patch.apply.marker.renderer", (Object[])new Object[]{this.getTooltipText()});
        }
    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved;

        public State(int index, int startLine, int endLine, boolean resolved) {
            super(index, startLine, endLine);
            this.myResolved = resolved;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE;

    }
}

