/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.BinaryPatchWriter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchWriter {
    public static void writePatches(@NotNull Project project, @NotNull String fileName, @NotNull String basePath, @NotNull List<? extends FilePatch> patches, @Nullable CommitContext commitContext, @NotNull Charset charset) throws IOException {
        PatchWriter.writePatches(project, fileName, basePath, patches, commitContext, charset, false);
    }

    public static void writePatches(@NotNull Project project, @NotNull String fileName, @Nullable String basePath, @NotNull List<? extends FilePatch> patches, @Nullable CommitContext commitContext, @NotNull Charset charset, boolean includeBinaries) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), charset);){
            PatchWriter.write(project, writer, basePath, patches, commitContext, includeBinaries);
        }
    }

    private static void write(@NotNull Project project, @NotNull Writer writer, @Nullable String basePath, @NotNull List<? extends FilePatch> patches, @Nullable CommitContext commitContext, boolean includeBinaries) throws IOException {
        String lineSeparator = CodeStyle.getSettings((Project)project).getLineSeparator();
        UnifiedDiffWriter.write(project, basePath, patches, writer, lineSeparator, PatchEP.EP_NAME.getExtensions((AreaInstance)project), commitContext);
        if (includeBinaries) {
            BinaryPatchWriter.writeBinaries(basePath, ContainerUtil.findAll(patches, BinaryFilePatch.class), writer);
        }
    }

    public static void writeAsPatchToClipboard(@NotNull Project project, @NotNull List<? extends FilePatch> patches, @NotNull String basePath, @Nullable CommitContext commitContext) throws IOException {
        StringWriter writer = new StringWriter();
        PatchWriter.write(project, writer, basePath, patches, commitContext, true);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(writer.toString()));
    }

    @NotNull
    public static VirtualFile calculateBaseForWritingPatch(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
        boolean multiVcs;
        File commonAncestor = ChangesUtil.findCommonAncestor(changes);
        boolean bl = multiVcs = ChangesUtil.getAffectedVcses(changes, (Project)project).size() != 1;
        if (multiVcs || commonAncestor == null) {
            return project.getBaseDir();
        }
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)project, (FilePath)VcsUtil.getFilePath((File)commonAncestor));
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)vcsRoot, (Object)project.getBaseDir());
    }
}

