/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitPatchWriter {
    @NonNls
    static final String GIT_DIFF_HEADER = "diff --git %s %s";
    @NonNls
    private static final String FILE_MODE_HEADER = "%s file mode %s";
    @NonNls
    private static final String INDEX_SHA1_HEADER = "index %s..%s";
    @NonNls
    private static final String FILE_RENAME_FROM_HEADER = "rename from %s";
    @NonNls
    private static final String FILE_RENAME_TO_HEADER = "rename to %s";

    @NotNull
    static String getFileModeHeader(@NotNull FileStatus fileStatus, int mode) {
        return String.format(FILE_MODE_HEADER, fileStatus == FileStatus.DELETED ? "deleted" : "new", mode);
    }

    @NotNull
    static String getIndexHeader(@NotNull String beforeHash, @NotNull String afterHash) {
        return String.format(INDEX_SHA1_HEADER, beforeHash, afterHash);
    }

    public static void writeGitHeader(@NotNull Writer writer, @Nullable String basePath, @NotNull FilePatch filePatch) throws IOException {
        String lineSeparator = "\n";
        writer.write(String.format(GIT_DIFF_HEADER, filePatch.getBeforeName(), filePatch.getAfterName()));
        writer.write(lineSeparator);
        File afterFile = new File(basePath, filePatch.getAfterName());
        if (filePatch.isDeletedFile()) {
            writer.write(GitPatchWriter.getFileModeHeader(FileStatus.DELETED, 100644));
            writer.write(lineSeparator);
        } else if (filePatch.isNewFile()) {
            writer.write(GitPatchWriter.getFileModeHeader(FileStatus.ADDED, !SystemInfo.isWindows && afterFile.canExecute() ? 100755 : 100644));
            writer.write(lineSeparator);
        } else if (!StringUtil.equals((CharSequence)filePatch.getBeforeName(), (CharSequence)filePatch.getAfterName())) {
            writer.write(String.format(FILE_RENAME_FROM_HEADER, filePatch.getBeforeName()));
            writer.write(lineSeparator);
            writer.write(String.format(FILE_RENAME_TO_HEADER, filePatch.getAfterName()));
            writer.write(lineSeparator);
        }
    }
}

