/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class CommonBinaryFilePatchInProgress<T extends FilePatch>
extends AbstractFilePatchInProgress<T> {
    protected CommonBinaryFilePatchInProgress(T patch, Collection<VirtualFile> autoBases, VirtualFile baseDir) {
        super(patch, autoBases, baseDir);
    }

    @Override
    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision != null) {
            return this.myNewContentRevision;
        }
        if (this.myPatch.getAfterFileName() != null) {
            FilePath newFilePath = this.getFilePath();
            this.myNewContentRevision = this.createNewContentRevision(newFilePath);
        }
        return this.myNewContentRevision;
    }

    @NotNull
    protected abstract BinaryContentRevision createNewContentRevision(@NotNull FilePath var1);

    @NotNull
    protected abstract Change createChange(Project var1);

    @NotNull
    protected FilePath getFilePath() {
        return FilePatchStatus.ADDED.equals((Object)this.myStatus) ? VcsUtil.getFilePath((File)this.myIoCurrentBase, (boolean)false) : this.detectNewFilePathForMovedOrModified();
    }

    @Override
    @NotNull
    public DiffRequestProducer getDiffRequestProducers(final Project project, PatchReader baseContents) {
        return new DiffRequestProducer(){

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                return PatchDiffRequestFactory.createDiffRequest(project, CommonBinaryFilePatchInProgress.this.createChange(project), this.getName(), context, indicator);
            }

            @NotNull
            public String getName() {
                File file1 = new File(VfsUtilCore.virtualToIoFile((VirtualFile)CommonBinaryFilePatchInProgress.this.getBase()), CommonBinaryFilePatchInProgress.this.myPatch.getAfterName() == null ? CommonBinaryFilePatchInProgress.this.myPatch.getBeforeName() : CommonBinaryFilePatchInProgress.this.myPatch.getAfterName());
                return FileUtil.toSystemDependentName((String)file1.getPath());
            }
        };
    }
}

