/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchDefaultExecutor
implements ApplyPatchExecutor<AbstractFilePatchInProgress> {
    protected final Project myProject;

    public ApplyPatchDefaultExecutor(Project project) {
        this.myProject = project;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void apply(@NotNull List<? extends FilePatch> remaining, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroupsToApply, final @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<? extends Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        CommitContext commitContext = new CommitContext();
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(this.myProject, additionalInfo, commitContext);
        final Collection<PatchApplier> appliers = this.getPatchAppliers(patchGroupsToApply, localList, commitContext);
        new Task.Backgroundable(this.myProject, VcsBundle.getString((String)"patch.apply.progress.title")){

            public void run(@NotNull ProgressIndicator indicator) {
                PatchApplier.executePatchGroup(appliers, localList);
            }
        }.queue();
    }

    @NotNull
    protected Collection<PatchApplier> getPatchAppliers(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroups, @Nullable LocalChangeList localList, @NotNull CommitContext commitContext) {
        ArrayList<PatchApplier> appliers = new ArrayList<PatchApplier>();
        for (VirtualFile base : patchGroups.keySet()) {
            appliers.add(new PatchApplier(this.myProject, base, ContainerUtil.map((Collection)patchGroups.get((Object)base), patchInProgress -> patchInProgress.getPatch()), localList, commitContext));
        }
        return appliers;
    }

    public static void applyAdditionalInfoBefore(Project project, @Nullable ThrowableComputable<? extends Map<String, Map<String, CharSequence>>, ? extends PatchSyntaxException> additionalInfo, @Nullable CommitContext commitContext) {
        List extensions = PatchEP.EP_NAME.getExtensions((AreaInstance)project);
        if (extensions.isEmpty() || additionalInfo == null) {
            return;
        }
        try {
            Map additionalInfoMap = (Map)additionalInfo.compute();
            for (Map.Entry entry : additionalInfoMap.entrySet()) {
                for (PatchEP extension : extensions) {
                    CharSequence charSequence = (CharSequence)((Map)entry.getValue()).get(extension.getName());
                    if (charSequence == null) continue;
                    extension.consumeContentBeforePatchApplied((String)entry.getKey(), charSequence, commitContext);
                }
            }
        }
        catch (PatchSyntaxException e) {
            VcsBalloonProblemNotifier.showOverChangesView(project, VcsBundle.message((String)"patch.apply.can.not.apply.additional.info.error", (Object[])new Object[]{e.getMessage()}), MessageType.ERROR, new NamedRunnable[0]);
        }
    }

    public static Set<String> pathsFromGroups(MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroups) {
        HashSet<String> selectedPaths = new HashSet<String>();
        Collection values = patchGroups.values();
        for (AbstractFilePatchInProgress value : values) {
            String path2 = value.getPatch().getBeforeName() == null ? value.getPatch().getAfterName() : value.getPatch().getBeforeName();
            selectedPaths.add(path2);
        }
        return selectedPaths;
    }
}

