/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.util.LineRange;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AppliedTextPatch {
    @NotNull
    private final List<AppliedSplitPatchHunk> mySplitPatchHunkList;

    public static AppliedTextPatch create(@NotNull List<? extends AppliedSplitPatchHunk> splitPatchHunkList) {
        ArrayList<AppliedSplitPatchHunk> hunks = new ArrayList<AppliedSplitPatchHunk>(splitPatchHunkList);
        BitSet appliedLines = new BitSet();
        for (int i = 0; i < hunks.size(); ++i) {
            AppliedSplitPatchHunk hunk = (AppliedSplitPatchHunk)hunks.get(i);
            LineRange appliedTo = hunk.getAppliedTo();
            if (appliedTo == null) continue;
            int nextAppliedLine = appliedLines.nextSetBit(appliedTo.start);
            if (nextAppliedLine != -1 && nextAppliedLine < appliedTo.end) {
                hunks.set(i, new AppliedSplitPatchHunk(hunk, -1, -1, HunkStatus.NOT_APPLIED));
                continue;
            }
            appliedLines.set(appliedTo.start, appliedTo.end, true);
        }
        ContainerUtil.sort(hunks, Comparator.comparingInt(o -> o.getLineRangeBefore().start));
        return new AppliedTextPatch(hunks);
    }

    private AppliedTextPatch(@NotNull List<AppliedSplitPatchHunk> hunks) {
        this.mySplitPatchHunkList = hunks;
    }

    @NotNull
    public List<AppliedSplitPatchHunk> getHunks() {
        return this.mySplitPatchHunkList;
    }

    public static class AppliedSplitPatchHunk {
        @NotNull
        private final HunkStatus myStatus;
        @NotNull
        private final List<String> myContextBefore;
        @NotNull
        private final List<String> myContextAfter;
        @NotNull
        private final List<String> myDeletedLines;
        @NotNull
        private final List<String> myInsertedLines;
        private final int myAppliedToLinesStart;
        private final int myAppliedToLinesEnd;
        private final int myStartLineBefore;
        private final int myStartLineAfter;

        public AppliedSplitPatchHunk(@NotNull GenericPatchApplier.SplitHunk splitHunk, int startLineApplied, int endLineApplied, @NotNull HunkStatus status) {
            this.myStatus = status;
            this.myAppliedToLinesStart = startLineApplied;
            this.myAppliedToLinesEnd = endLineApplied;
            this.myStartLineBefore = splitHunk.getStartLineBefore();
            this.myStartLineAfter = splitHunk.getStartLineAfter();
            this.myContextBefore = splitHunk.getContextBefore();
            this.myContextAfter = splitHunk.getContextAfter();
            this.myDeletedLines = new ArrayList<String>();
            this.myInsertedLines = new ArrayList<String>();
            for (BeforeAfter<List<String>> step2 : splitHunk.getPatchSteps()) {
                this.myDeletedLines.addAll((Collection)step2.getBefore());
                this.myInsertedLines.addAll((Collection)step2.getAfter());
            }
        }

        private AppliedSplitPatchHunk(@NotNull AppliedSplitPatchHunk hunk, int appliedToLinesStart, int appliedToLinesEnd, @NotNull HunkStatus status) {
            this.myStatus = status;
            this.myAppliedToLinesStart = appliedToLinesStart;
            this.myAppliedToLinesEnd = appliedToLinesEnd;
            this.myContextBefore = hunk.myContextBefore;
            this.myContextAfter = hunk.myContextAfter;
            this.myDeletedLines = hunk.myDeletedLines;
            this.myInsertedLines = hunk.myInsertedLines;
            this.myStartLineBefore = hunk.myStartLineBefore;
            this.myStartLineAfter = hunk.myStartLineAfter;
        }

        public LineRange getAppliedTo() {
            if (this.myStatus == HunkStatus.NOT_APPLIED) {
                return null;
            }
            return new LineRange(this.myAppliedToLinesStart, this.myAppliedToLinesEnd);
        }

        @NotNull
        public LineRange getLineRangeBefore() {
            int start2 = this.myStartLineBefore;
            return new LineRange(start2, start2 + this.myContextBefore.size() + this.myDeletedLines.size() + this.myContextAfter.size());
        }

        @NotNull
        public LineRange getLineRangeAfter() {
            int start2 = this.myStartLineAfter;
            return new LineRange(start2, start2 + this.myContextBefore.size() + this.myInsertedLines.size() + this.myContextAfter.size());
        }

        @NotNull
        public HunkStatus getStatus() {
            return this.myStatus;
        }

        @NotNull
        public List<String> getContextBefore() {
            return this.myContextBefore;
        }

        @NotNull
        public List<String> getContextAfter() {
            return this.myContextAfter;
        }

        @NotNull
        public List<String> getDeletedLines() {
            return this.myDeletedLines;
        }

        @NotNull
        public List<String> getInsertedLines() {
            return this.myInsertedLines;
        }
    }

    public static enum HunkStatus {
        ALREADY_APPLIED,
        EXACTLY_APPLIED,
        NOT_APPLIED;

    }
}

