/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class IssueLinkHtmlRenderer {
    private IssueLinkHtmlRenderer() {
    }

    @NotNull
    public static String formatTextIntoHtml(@NotNull Project project, @NotNull String c) {
        return "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground(), (Color)JBUI.CurrentTheme.Link.linkColor(), null) + "</head><body>" + IssueLinkHtmlRenderer.formatTextWithLinks(project, c) + "</body></html>";
    }

    @NotNull
    public static String formatTextWithLinks(@NotNull Project project, @NotNull String str, @NotNull Convertor<? super String, String> convertor) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        String comment = XmlStringUtil.escapeString((String)VcsUtil.trimCommitMessageToSaneSize((String)str), (boolean)false);
        StringBuilder commentBuilder = new StringBuilder();
        IssueNavigationConfiguration config = IssueNavigationConfiguration.getInstance((Project)project);
        List list = config.findIssueLinks((CharSequence)comment);
        int pos = 0;
        for (IssueNavigationConfiguration.LinkMatch match : list) {
            TextRange range = match.getRange();
            commentBuilder.append((String)convertor.convert((Object)comment.substring(pos, range.getStartOffset()))).append("<a href=\"").append(match.getTargetUrl()).append("\">");
            commentBuilder.append(range.substring(comment)).append("</a>");
            pos = range.getEndOffset();
        }
        commentBuilder.append((String)convertor.convert((Object)comment.substring(pos)));
        comment = commentBuilder.toString();
        return comment.replace("\n", "<br>");
    }

    @NotNull
    public static String formatTextWithLinks(@NotNull Project project, @NotNull String c) {
        return IssueLinkHtmlRenderer.formatTextWithLinks(project, c, (Convertor<? super String, String>)Convertor.self());
    }
}

