/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.reference;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ignore.cache.IgnorePatternsMatchedFilesCache;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreFile;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreReferenceSet
extends FileReferenceSet {
    @NotNull
    private final IgnorePatternsMatchedFilesCache myIgnorePatternsMatchedFilesCache;
    private final PatternCache myPatternCache;

    public IgnoreReferenceSet(@NotNull IgnoreEntry element) {
        super((PsiElement)element);
        this.myIgnorePatternsMatchedFilesCache = IgnorePatternsMatchedFilesCache.getInstance(element.getProject());
        this.myPatternCache = PatternCache.getInstance(element.getProject());
    }

    public FileReference createFileReference(TextRange range, int index, String text2) {
        return new IgnoreReference(this, range, index, text2);
    }

    public boolean isEndingSlashNotAllowed() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        VirtualFile affectedRoot;
        Language language;
        PsiDirectory containingDirectory;
        PsiFile containingFile = this.getElement().getContainingFile();
        PsiDirectory psiDirectory = containingDirectory = containingFile.getParent() != null ? containingFile.getParent() : containingFile.getOriginalFile().getContainingDirectory();
        if (containingDirectory == null && (language = containingFile.getLanguage()) instanceof IgnoreLanguage && (affectedRoot = ((IgnoreLanguage)language).getAffectedRoot(containingFile.getProject(), containingFile.getOriginalFile().getVirtualFile())) != null) {
            containingDirectory = containingFile.getManager().findDirectory(affectedRoot);
        }
        return containingDirectory != null ? Collections.singletonList(containingDirectory) : super.computeDefaultContexts();
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return item -> {
            Project project = item.getProject();
            PsiFile originalFile = this.getElement().getContainingFile().getOriginalFile();
            VirtualFile ignoreFile = originalFile.getVirtualFile();
            Language language = originalFile.getLanguage();
            if (!(language instanceof IgnoreLanguage)) {
                return false;
            }
            VirtualFile ignoreFileAffectedRoot = ((IgnoreLanguage)language).getAffectedRoot(project, ignoreFile);
            VirtualFile ignoreFileVcsRoot = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)ignoreFileAffectedRoot);
            if (ignoreFileVcsRoot == null) {
                return false;
            }
            return IgnoreReferenceSet.isFileUnderSameVcsRoot(project, ignoreFileVcsRoot, item.getVirtualFile());
        };
    }

    @Nullable
    public FileReference getLastReference() {
        FileReference lastReference = super.getLastReference();
        if (lastReference != null && lastReference.getCanonicalText().endsWith(this.getSeparatorString())) {
            return this.myReferences != null && this.myReferences.length > 1 ? this.myReferences[this.myReferences.length - 2] : null;
        }
        return lastReference;
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return false;
    }

    protected void reparse() {
        int nextSlash;
        ProgressManager.checkCanceled();
        String str = StringUtil.trimEnd((String)this.getPathString(), (String)this.getSeparatorString());
        ArrayList<FileReference> referencesList = new ArrayList<FileReference>();
        String separatorString = this.getSeparatorString();
        int sepLen = separatorString.length();
        int currentSlash = -sepLen;
        int startInElement = this.getStartInElement();
        while (currentSlash + sepLen < str.length() && Character.isWhitespace(str.charAt(currentSlash + sepLen))) {
            ++currentSlash;
        }
        if (currentSlash + sepLen + sepLen < str.length() && str.substring(currentSlash + sepLen, currentSlash + sepLen + sepLen).equals(separatorString)) {
            currentSlash += sepLen;
        }
        int index = 0;
        if (str.equals(separatorString)) {
            FileReference fileReference = this.createFileReference(new TextRange(startInElement, startInElement + sepLen), index++, separatorString);
            referencesList.add(fileReference);
        }
        do {
            ProgressManager.checkCanceled();
            nextSlash = str.indexOf(separatorString, currentSlash + sepLen);
            String subReferenceText = nextSlash > 0 ? str.substring(0, nextSlash) : str;
            TextRange range = new TextRange(startInElement + currentSlash + sepLen, startInElement + (nextSlash > 0 ? nextSlash : str.length()));
            FileReference ref = this.createFileReference(range, index++, subReferenceText);
            referencesList.add(ref);
        } while ((currentSlash = nextSlash) >= 0);
        this.myReferences = referencesList.toArray(FileReference.EMPTY);
    }

    protected String getNewAbsolutePath(@NotNull PsiFileSystemItem root, @NotNull String relativePath) {
        String relativeToIgnoreFileParent;
        VirtualFile relativeFile;
        PsiFile ignoreFile = this.getContainingFile();
        VirtualFile rootVF = root.getVirtualFile();
        if (rootVF != null && ignoreFile != null && ignoreFile.getVirtualFile() != null && ignoreFile.getVirtualFile().getParent() != null && !rootVF.equals(ignoreFile.getVirtualFile().getParent()) && (relativeFile = rootVF.findFileByRelativePath(relativePath)) != null && (relativeToIgnoreFileParent = VfsUtilCore.getRelativePath((VirtualFile)relativeFile, (VirtualFile)ignoreFile.getVirtualFile().getParent())) != null) {
            return this.absoluteUrlNeedsStartSlash() ? "/" + relativeToIgnoreFileParent : relativeToIgnoreFileParent;
        }
        return super.getNewAbsolutePath(root, relativePath);
    }

    private static boolean isFileUnderSameVcsRoot(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull VirtualFile file) {
        VirtualFile fileVcsRoot = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)file);
        return fileVcsRoot != null && vcsRoot.equals(fileVcsRoot);
    }

    private class IgnoreReference
    extends FileReference {
        private IgnoreReference(FileReferenceSet fileReferenceSet, TextRange range, int index, String text2) {
            super(fileReferenceSet, range, index, text2);
        }

        protected void innerResolveInContext(@NotNull String text2, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> result2, boolean caseSensitive) {
            ProgressManager.checkCanceled();
            super.innerResolveInContext(text2, context, result2, caseSensitive);
            PsiFile containingFile = IgnoreReferenceSet.this.getContainingFile();
            if (!(containingFile instanceof IgnoreFile)) {
                return;
            }
            VirtualFile ignoreFileAffectedRoot = ((IgnoreLanguage)containingFile.getLanguage()).getAffectedRoot(context.getProject(), containingFile.getVirtualFile());
            if (ignoreFileAffectedRoot == null) {
                return;
            }
            VirtualFile ignoreFileVcsRoot = VcsUtil.getVcsRootFor((Project)context.getProject(), (VirtualFile)ignoreFileAffectedRoot);
            if (ignoreFileVcsRoot == null) {
                return;
            }
            VirtualFile contextVirtualFile = context.getVirtualFile();
            if (contextVirtualFile != null) {
                IgnoreEntry entry = (IgnoreEntry)this.getFileReferenceSet().getElement();
                String current = this.getCanonicalText();
                Pattern pattern = IgnoreReferenceSet.this.myPatternCache.createPattern(current, entry.getSyntax());
                if (pattern != null) {
                    PsiDirectory parent = this.getElement().getContainingFile().getParent();
                    VirtualFile root = parent != null ? parent.getVirtualFile() : null;
                    PsiManager psiManager = this.getElement().getManager();
                    ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(IgnoreReferenceSet.this.myIgnorePatternsMatchedFilesCache.getFilesForPattern(pattern));
                    if (files.isEmpty()) {
                        files.addAll(ContainerUtil.filter((Object[])context.getVirtualFile().getChildren(), virtualFile -> IgnoreReferenceSet.isFileUnderSameVcsRoot(context.getProject(), ignoreFileVcsRoot, virtualFile)));
                    }
                    for (VirtualFile file : files) {
                        PsiFileSystemItem psiFileSystemItem;
                        ProgressManager.checkCanceled();
                        if (!IgnoreReferenceSet.isFileUnderSameVcsRoot(context.getProject(), ignoreFileVcsRoot, file)) continue;
                        String relativeToIgnoreFileVcsRoot = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)ignoreFileVcsRoot);
                        String name = root != null ? VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root) : (relativeToIgnoreFileVcsRoot != null ? relativeToIgnoreFileVcsRoot : file.getName());
                        if (!RegexUtil.match(pattern, name) || (psiFileSystemItem = this.getPsiFileSystemItem(psiManager, file)) == null) continue;
                        result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)psiFileSystemItem));
                    }
                }
            }
        }

        @Nullable
        private PsiFileSystemItem getPsiFileSystemItem(@NotNull PsiManager manager, @NotNull VirtualFile file) {
            if (!file.isValid()) {
                return null;
            }
            return file.isDirectory() ? manager.findDirectory(file) : manager.findFile(file);
        }
    }
}

