/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.codeInspection;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreFileRemoveEntryFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public IgnoreFileRemoveEntryFix(@NotNull IgnoreEntry entry) {
        super((PsiElement)entry);
    }

    @NotNull
    public String getText() {
        return VcsBundle.message((String)"ignore.quick.fix.remove.entry", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement instanceof IgnoreEntry) {
            IgnoreFileRemoveEntryFix.removePreviousCrlfIfAny(startElement);
            startElement.delete();
        }
    }

    private static void removePreviousCrlfIfAny(PsiElement startElement) {
        ASTNode node = TreeUtil.findSiblingBackward((ASTNode)startElement.getNode(), (IElementType)IgnoreTypes.CRLF);
        if (node != null) {
            node.getPsi().delete();
        }
    }

    @NotNull
    public String getFamilyName() {
        return VcsBundle.message((String)"ignore.codeInspection.group", (Object[])new Object[0]);
    }
}

