/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ignore.codeInspection.IgnoreFileRemoveEntryFix;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreFile;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreFileDuplicateEntryInspection
extends LocalInspectionTool {
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof IgnoreFile)) {
            return null;
        }
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        final MultiMap entries = MultiMap.create();
        file.acceptChildren((PsiElementVisitor)new IgnoreVisitor(){

            @Override
            public void visitEntry(@NotNull IgnoreEntry entry) {
                entries.putValue((Object)entry.getText(), (Object)entry);
                super.visitEntry(entry);
            }
        });
        for (Map.Entry stringCollectionEntry : entries.entrySet()) {
            Iterator iterator = ((Collection)stringCollectionEntry.getValue()).iterator();
            iterator.next();
            while (iterator.hasNext()) {
                IgnoreEntry entry = (IgnoreEntry)iterator.next();
                problemsHolder.registerProblem((PsiElement)entry, VcsBundle.message((String)"ignore.codeInspection.duplicateEntry.message", (Object[])new Object[0]), new LocalQuickFix[]{new IgnoreFileRemoveEntryFix(entry)});
            }
        }
        return problemsHolder.getResultsArray();
    }

    public boolean runForWholeFile() {
        return true;
    }
}

