/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.codeInsight;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntryDirectory;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntryFile;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IgnoreDirectoryMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        for (PsiElement psiElement : elements) {
            PsiElement leafElement;
            ProgressManager.checkCanceled();
            if (!(psiElement instanceof IgnoreEntryFile)) continue;
            boolean isDirectory = psiElement instanceof IgnoreEntryDirectory;
            if (!isDirectory) {
                IgnoreEntryFile entry = (IgnoreEntryFile)psiElement;
                VirtualFile parent = psiElement.getContainingFile().getVirtualFile().getParent();
                Project project = psiElement.getProject();
                VirtualFile projectDir = project.getBaseDir();
                if (parent == null || projectDir == null) continue;
                PatternCache patternCache = PatternCache.getInstance(psiElement.getProject());
                Pattern pattern = patternCache.createPattern(entry);
                boolean bl = isDirectory = pattern != null && IgnoreDirectoryMarkerProvider.isDirectoryExist(parent, pattern);
            }
            if (!isDirectory || (leafElement = IgnoreDirectoryMarkerProvider.firstLeafOrNull(psiElement)) == null) continue;
            result2.add(new LineMarkerInfo(leafElement, psiElement.getTextRange(), PlatformIcons.FOLDER_ICON, null, null, GutterIconRenderer.Alignment.CENTER));
        }
    }

    @Nullable
    private static PsiElement firstLeafOrNull(@NotNull PsiElement element) {
        LeafElement firstLeaf = TreeUtil.findFirstLeaf((ASTNode)element.getNode());
        return firstLeaf != null ? firstLeaf.getPsi() : null;
    }

    private static boolean isDirectoryExist(@NotNull VirtualFile root, @NotNull Pattern pattern) {
        Ref found = Ref.create((Object)false);
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, file -> file.isDirectory(), dir -> {
            ProgressManager.checkCanceled();
            String path2 = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)root);
            if (path2 != null && RegexUtil.match(pattern, path2)) {
                found.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)found.get();
    }
}

