/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterPriority;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.DirectoryChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureFilteringStrategy
implements ChangeListFilteringStrategy {
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private MyUI myUI;
    private final Project myProject;
    private final List<FilePath> mySelection = new ArrayList<FilePath>();

    public StructureFilteringStrategy(Project project) {
        this.myProject = project;
    }

    @NotNull
    public CommittedChangesFilterKey getKey() {
        return new CommittedChangesFilterKey(this.toString(), CommittedChangesFilterPriority.STRUCTURE);
    }

    public String toString() {
        return VcsBundle.message((String)"filter.structure.name", (Object[])new Object[0]);
    }

    @Nullable
    public JComponent getFilterUI() {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        return this.myUI.getComponent();
    }

    public void setFilterBase(@NotNull List<? extends CommittedChangeList> changeLists) {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        this.myUI.reset();
        this.myUI.append(changeLists);
    }

    public void addChangeListener(@NotNull ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeChangeListener(@NotNull ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void resetFilterBase() {
        this.myUI.reset();
    }

    public void appendFilterBase(@NotNull List<? extends CommittedChangeList> changeLists) {
        this.myUI.append(changeLists);
    }

    @NotNull
    public List<CommittedChangeList> filterChangeLists(@NotNull List<? extends CommittedChangeList> changeLists) {
        if (this.mySelection.size() == 0) {
            return new ArrayList<CommittedChangeList>(changeLists);
        }
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        for (CommittedChangeList committedChangeList : changeLists) {
            if (!this.listMatchesSelection(committedChangeList)) continue;
            result2.add(committedChangeList);
        }
        return result2;
    }

    private boolean listMatchesSelection(CommittedChangeList list) {
        for (Change change : list.getChanges()) {
            FilePath path2 = ChangesUtil.getFilePath((Change)change);
            for (FilePath selPath : this.mySelection) {
                if (!path2.isUnder(selPath, false)) continue;
                return true;
            }
        }
        return false;
    }

    private class MyUI {
        private final JComponent myScrollPane;
        private final Tree myStructureTree;
        private boolean myRendererInitialized;
        private final Set<FilePath> myFilePaths = new HashSet<FilePath>();
        private TreeState myState;

        MyUI() {
            this.myStructureTree = new Tree();
            this.myStructureTree.setRootVisible(false);
            this.myStructureTree.setShowsRootHandles(true);
            this.myStructureTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    ArrayList filePaths = new ArrayList(StructureFilteringStrategy.this.mySelection);
                    StructureFilteringStrategy.this.mySelection.clear();
                    TreePath[] selectionPaths = MyUI.this.myStructureTree.getSelectionPaths();
                    if (selectionPaths != null) {
                        for (TreePath selectionPath : selectionPaths) {
                            StructureFilteringStrategy.this.mySelection.addAll(MyUI.this.getFilePathsUnder((ChangesBrowserNode)selectionPath.getLastPathComponent()));
                        }
                    }
                    if (Comparing.haveEqualElements(filePaths, (Collection)StructureFilteringStrategy.this.mySelection)) {
                        return;
                    }
                    for (ChangeListener listener2 : StructureFilteringStrategy.this.myListeners) {
                        listener2.stateChanged(new ChangeEvent(this));
                    }
                }
            });
            this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myStructureTree);
        }

        @NotNull
        private List<FilePath> getFilePathsUnder(@NotNull ChangesBrowserNode<?> node) {
            List<FilePath> result2 = Collections.emptyList();
            Object userObject = node.getUserObject();
            if (userObject instanceof FilePath) {
                result2 = Collections.singletonList((FilePath)userObject);
            } else if (userObject instanceof Module) {
                result2 = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)((Module)userObject)).getContentRoots(), VcsUtil::getFilePath);
            }
            return result2;
        }

        public void initRenderer() {
            if (!this.myRendererInitialized) {
                this.myRendererInitialized = true;
                this.myStructureTree.setCellRenderer((TreeCellRenderer)((Object)new ChangesBrowserNodeRenderer(StructureFilteringStrategy.this.myProject, BooleanGetter.FALSE, false)));
            }
        }

        public JComponent getComponent() {
            return this.myScrollPane;
        }

        public void reset() {
            this.myFilePaths.clear();
            this.myState = TreeState.createOn((JTree)this.myStructureTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            this.myStructureTree.setModel((TreeModel)TreeModelBuilder.buildEmpty());
        }

        public void append(List<? extends CommittedChangeList> changeLists) {
            TreeState localState = this.myState != null && this.myFilePaths.isEmpty() ? this.myState : TreeState.createOn((JTree)this.myStructureTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            for (CommittedChangeList committedChangeList : changeLists) {
                for (Change change : committedChangeList.getChanges()) {
                    FilePath path2 = ChangesUtil.getFilePath((Change)change);
                    if (path2.getParentPath() == null) continue;
                    this.myFilePaths.add(path2.getParentPath());
                }
            }
            this.myStructureTree.setModel((TreeModel)TreeModelBuilder.buildFromFilePaths(StructureFilteringStrategy.this.myProject, new DirectoryChangesGroupingPolicy.Factory(), this.myFilePaths));
            localState.applyTo((JTree)this.myStructureTree, this.myStructureTree.getModel().getRoot());
            this.myStructureTree.revalidate();
            this.myStructureTree.repaint();
            this.initRenderer();
        }
    }
}

