/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.ChangeListDetailsAction;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.ChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListByDateComparator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CompositeChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.DateChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.SelectFilteringAction;
import com.intellij.openapi.vcs.changes.committed.SelectGroupingAction;
import com.intellij.openapi.vcs.changes.committed.WiseSplitter;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeCopyProvider;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommittedChangesTreeBrowser
extends JPanel
implements DataProvider,
Disposable,
DecoratorManager {
    private static final Border RIGHT_BORDER = IdeBorderFactory.createBorder((int)3);
    private final Project myProject;
    @NotNull
    private final ChangesBrowserTree myChangesTree;
    private final MyRepositoryChangesViewer myDetailsView;
    private List<CommittedChangeList> myChangeLists;
    private List<CommittedChangeList> mySelectedChangeLists;
    @NotNull
    private ChangeListGroupingStrategy myGroupingStrategy = new DateChangeListGroupingStrategy();
    private final CompositeChangeListFilteringStrategy myFilteringStrategy = new CompositeChangeListFilteringStrategy();
    private final JPanel myLeftPanel;
    private final FilterChangeListener myFilterChangeListener = new FilterChangeListener();
    private final SplitterProportionsData mySplitterProportionsData = new SplitterProportionsDataImpl();
    private final CopyProvider myCopyProvider;
    private final TreeExpander myTreeExpander;
    private String myHelpId;
    public static final Topic<CommittedChangesReloadListener> ITEMS_RELOADED = new Topic("ITEMS_RELOADED", CommittedChangesReloadListener.class);
    private final List<CommittedChangeListDecorator> myDecorators;
    @NonNls
    public static final String ourHelpId = "reference.changesToolWindow.incoming";
    private WiseSplitter myInnerSplitter;
    private final MessageBusConnection myConnection;
    private TreeState myState;

    public CommittedChangesTreeBrowser(Project project, List<? extends CommittedChangeList> changeLists) {
        super(new BorderLayout());
        this.myProject = project;
        this.myDecorators = new LinkedList<CommittedChangeListDecorator>();
        this.myChangeLists = new ArrayList<CommittedChangeList>(changeLists);
        this.myChangesTree = new ChangesBrowserTree();
        this.myChangesTree.setRootVisible(false);
        this.myChangesTree.setShowsRootHandles(true);
        this.myChangesTree.setCellRenderer((TreeCellRenderer)((Object)new CommittedChangeListRenderer(project, this.myDecorators)));
        TreeUtil.expandAll((JTree)((Object)this.myChangesTree));
        this.myChangesTree.setExpandableItemsEnabled(false);
        this.myDetailsView = new MyRepositoryChangesViewer(project);
        this.myChangesTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CommittedChangesTreeBrowser.this.updateBySelectionChange();
            }
        });
        this.myChangesTree.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CommittedChangesTreeBrowser.this.myChangesTree.invalidateNodeSizes();
            }
        });
        TreeLinkMouseListener linkMouseListener = new TreeLinkMouseListener((ColoredTreeCellRenderer)new CommittedChangeListRenderer(project, this.myDecorators));
        linkMouseListener.installOn((Component)((Object)this.myChangesTree));
        this.myLeftPanel = new JPanel(new BorderLayout());
        this.initSplitters();
        this.updateBySelectionChange();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        CustomShortcutSet quickdocShortcuts = new CustomShortcutSet(keymap.getShortcuts("QuickJavaDoc"));
        EmptyAction.registerWithShortcutSet((String)"CommittedChanges.Details", (ShortcutSet)quickdocShortcuts, (JComponent)this);
        this.myCopyProvider = new TreeCopyProvider((JTree)((Object)this.myChangesTree));
        this.myTreeExpander = new DefaultTreeExpander((JTree)((Object)this.myChangesTree));
        this.myDetailsView.addToolbarAction(ActionManager.getInstance().getAction("Vcs.ShowTabbedFileHistory"));
        this.myHelpId = ourHelpId;
        this.myDetailsView.getDiffAction().registerCustomShortcutSet(this.myDetailsView.getDiffAction().getShortcutSet(), (JComponent)((Object)this.myChangesTree));
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(ITEMS_RELOADED, (Object)new CommittedChangesReloadListener(){

            @Override
            public void itemsReloaded() {
            }

            @Override
            public void emptyRefresh() {
                CommittedChangesTreeBrowser.this.updateGrouping();
            }
        });
    }

    private void initSplitters() {
        Splitter filterSplitter = new Splitter(false, 0.5f);
        filterSplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myChangesTree)));
        this.myLeftPanel.add((Component)filterSplitter, "Center");
        Splitter mainSplitter = new Splitter(false, 0.7f);
        mainSplitter.setFirstComponent((JComponent)this.myLeftPanel);
        mainSplitter.setSecondComponent((JComponent)this.myDetailsView);
        this.add((Component)mainSplitter, "Center");
        this.myInnerSplitter = new WiseSplitter(() -> {
            filterSplitter.doLayout();
            this.updateModel();
        }, filterSplitter);
        Disposer.register((Disposable)this, (Disposable)this.myInnerSplitter);
        this.mySplitterProportionsData.externalizeFromDimensionService("CommittedChanges.SplitterProportions");
        this.mySplitterProportionsData.restoreSplitterProportions((Component)this);
    }

    public void addFilter(ChangeListFilteringStrategy strategy) {
        this.myFilteringStrategy.addStrategy(strategy.getKey(), strategy);
        strategy.addChangeListener((ChangeListener)this.myFilterChangeListener);
    }

    private void updateGrouping() {
        if (this.myGroupingStrategy.changedSinceApply()) {
            ApplicationManager.getApplication().invokeLater(() -> this.updateModel(), ModalityState.NON_MODAL);
        }
    }

    private TreeModel buildTreeModel(List<? extends CommittedChangeList> filteredChangeLists) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(root);
        filteredChangeLists = ContainerUtil.sorted(filteredChangeLists, this.myGroupingStrategy.getComparator());
        this.myGroupingStrategy.beforeStart();
        DefaultMutableTreeNode lastGroupNode = null;
        String lastGroupName = null;
        for (CommittedChangeList list : filteredChangeLists) {
            String groupName = StringUtil.notNullize((String)this.myGroupingStrategy.getGroupName(list));
            if (!Objects.equals(groupName, lastGroupName)) {
                lastGroupName = groupName;
                lastGroupNode = new DefaultMutableTreeNode(lastGroupName);
                root.add(lastGroupNode);
            }
            lastGroupNode.add(new DefaultMutableTreeNode(list));
        }
        return model;
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    public StatusText getEmptyText() {
        return this.myChangesTree.getEmptyText();
    }

    public void setToolBar(JComponent toolBar) {
        this.myLeftPanel.add((Component)toolBar, "North");
        this.myDetailsView.syncSizeWithToolbar(toolBar);
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.mySplitterProportionsData.saveSplitterProportions((Component)this);
        this.mySplitterProportionsData.externalizeToDimensionService("CommittedChanges.SplitterProportions");
    }

    public void setItems(@NotNull List<? extends CommittedChangeList> items, CommittedChangesBrowserUseCase useCase) {
        this.myDetailsView.setUseCase(useCase);
        this.myChangeLists = new ArrayList<CommittedChangeList>(items);
        this.myFilteringStrategy.setFilterBase(items);
        ((CommittedChangesReloadListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, ITEMS_RELOADED)).itemsReloaded();
        this.updateModel();
    }

    private void updateModel() {
        TreeState state = TreeState.createOn((JTree)((Object)this.myChangesTree), (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myChangesTree.getModel().getRoot()));
        List<CommittedChangeList> filteredChangeLists = this.myFilteringStrategy.filterChangeLists(this.myChangeLists);
        this.myChangesTree.setModel(this.buildTreeModel(filteredChangeLists));
        state.applyTo((JTree)((Object)this.myChangesTree));
        TreeUtil.expandAll((JTree)((Object)this.myChangesTree));
    }

    public void setGroupingStrategy(@NotNull ChangeListGroupingStrategy strategy) {
        this.myGroupingStrategy = strategy;
        this.updateModel();
    }

    @NotNull
    public ChangeListGroupingStrategy getGroupingStrategy() {
        return this.myGroupingStrategy;
    }

    private void updateBySelectionChange() {
        ArrayList<CommittedChangeList> selection = new ArrayList<CommittedChangeList>();
        TreePath[] selectionPaths = this.myChangesTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath path2 : selectionPaths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
                if (!(node.getUserObject() instanceof CommittedChangeList)) continue;
                selection.add((CommittedChangeList)node.getUserObject());
            }
        }
        if (!selection.equals(this.mySelectedChangeLists)) {
            this.mySelectedChangeLists = selection;
            this.myDetailsView.setChangesToDisplay(CommittedChangesTreeBrowser.collectChanges(this.mySelectedChangeLists, false));
        }
    }

    @NotNull
    public static List<Change> collectChanges(List<? extends CommittedChangeList> selectedChangeLists, boolean withMovedTrees) {
        selectedChangeLists.sort(CommittedChangeListByDateComparator.ASCENDING);
        ArrayList changes = new ArrayList();
        for (CommittedChangeList committedChangeList : selectedChangeLists) {
            changes.addAll(withMovedTrees ? committedChangeList.getChangesWithMovedTrees() : committedChangeList.getChanges());
        }
        return CommittedChangesTreeBrowser.zipChanges(changes);
    }

    @NotNull
    public static List<Change> zipChanges(@NotNull List<? extends Change> changes) {
        MultiMap map2 = MultiMap.createLinked();
        for (Change change : changes) {
            FilePath aPath;
            ContentRevision bRev = change.getBeforeRevision();
            ContentRevision aRev = change.getAfterRevision();
            FilePath bPath = bRev != null ? bRev.getFile() : null;
            FilePath filePath = aPath = aRev != null ? aRev.getFile() : null;
            if (bRev == null) {
                map2.putValue((Object)aPath, (Object)change);
                continue;
            }
            Collection bucket = map2.get((Object)bPath);
            if (bucket.isEmpty()) {
                map2.putValue((Object)aPath, (Object)change);
                continue;
            }
            Change oldChange = (Change)bucket.iterator().next();
            bucket.remove(oldChange);
            ContentRevision oldRevision = oldChange.getBeforeRevision();
            if (oldRevision == null && aRev == null) continue;
            map2.putValue((Object)aPath, (Object)new Change(oldRevision, aRev));
        }
        Collection deleted = map2.remove(null);
        if (deleted != null) {
            for (Change change : deleted) {
                map2.putValue((Object)change.getBeforeRevision().getFile(), (Object)change);
            }
        }
        return new ArrayList<Change>(map2.values());
    }

    private List<CommittedChangeList> getSelectedChangeLists() {
        return TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this.myChangesTree), CommittedChangeList.class);
    }

    public void setTableContextMenu(ActionGroup group, List<? extends AnAction> auxiliaryActions) {
        DefaultActionGroup menuGroup = new DefaultActionGroup();
        menuGroup.add((AnAction)group);
        for (AnAction anAction : auxiliaryActions) {
            menuGroup.add(anAction);
        }
        menuGroup.add(ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myChangesTree), (ActionGroup)menuGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    public void removeFilteringStrategy(@NotNull CommittedChangesFilterKey key) {
        ChangeListFilteringStrategy strategy = this.myFilteringStrategy.removeStrategy(key);
        if (strategy != null) {
            strategy.removeChangeListener((ChangeListener)this.myFilterChangeListener);
        }
        this.myInnerSplitter.remove(key);
    }

    public boolean setFilteringStrategy(@NotNull ChangeListFilteringStrategy filteringStrategy) {
        if (this.myInnerSplitter.canAdd()) {
            filteringStrategy.addChangeListener((ChangeListener)this.myFilterChangeListener);
            CommittedChangesFilterKey key = filteringStrategy.getKey();
            this.myFilteringStrategy.addStrategy(key, filteringStrategy);
            this.myFilteringStrategy.setFilterBase(this.myChangeLists);
            JComponent filterUI = filteringStrategy.getFilterUI();
            if (filterUI != null) {
                this.myInnerSplitter.add(key, filterUI);
            }
            return true;
        }
        return false;
    }

    public ActionToolbar createGroupFilterToolbar(Project project, ActionGroup leadGroup, @Nullable ActionGroup tailGroup, List<? extends AnAction> extra) {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)leadGroup);
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)new SelectFilteringAction(project, this));
        toolbarGroup.add((AnAction)new SelectGroupingAction(project, this));
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)((Object)this.myChangesTree));
        CollapseAllAction collapseAllAction = new CollapseAllAction((JTree)((Object)this.myChangesTree));
        expandAllAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ExpandAll"), (JComponent)((Object)this.myChangesTree));
        collapseAllAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CollapseAll"), (JComponent)((Object)this.myChangesTree));
        toolbarGroup.add((AnAction)expandAllAction);
        toolbarGroup.add((AnAction)collapseAllAction);
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"));
        toolbarGroup.add((AnAction)new ContextHelpAction(this.myHelpId));
        if (tailGroup != null) {
            toolbarGroup.add((AnAction)tailGroup);
        }
        for (AnAction anAction : extra) {
            toolbarGroup.add(anAction);
        }
        return ActionManager.getInstance().createActionToolbar("CommittedChangesTree", (ActionGroup)toolbarGroup, true);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return CommittedChangesTreeBrowser.collectChanges(this.getSelectedChangeLists(), false).toArray(new Change[0]);
        }
        if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
            return this.myChangesTree.getSelectionCount() > 0;
        }
        if (VcsDataKeys.CHANGES_WITH_MOVED_CHILDREN.is(dataId)) {
            return CommittedChangesTreeBrowser.collectChanges(this.getSelectedChangeLists(), true).toArray(new Change[0]);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            List<CommittedChangeList> changeLists = this.getSelectedChangeLists();
            return !changeLists.isEmpty() ? changeLists.toArray(new CommittedChangeList[0]) : null;
        }
        if (VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.is(dataId)) {
            return this.myDetailsView.getSelectedChanges().toArray(new Change[0]);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<Change> changes = CommittedChangesTreeBrowser.collectChanges(this.getSelectedChangeLists(), false);
            return ChangesUtil.getNavigatableArray((Project)this.myProject, (Stream)ChangesUtil.getFiles(changes.stream()));
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return null;
    }

    public TreeExpander getTreeExpander() {
        return this.myTreeExpander;
    }

    public void repaintTree() {
        this.myChangesTree.revalidate();
        this.myChangesTree.repaint();
    }

    public void install(@NotNull CommittedChangeListDecorator decorator) {
        this.myDecorators.add(decorator);
        this.repaintTree();
    }

    public void remove(@NotNull CommittedChangeListDecorator decorator) {
        this.myDecorators.remove(decorator);
        this.repaintTree();
    }

    public void reportLoadedLists(@NotNull CommittedChangeListsListener listener2) {
        ArrayList<CommittedChangeList> lists = new ArrayList<CommittedChangeList>(this.myChangeLists);
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
            listener2.onBeforeStartReport();
            for (CommittedChangeList list : lists) {
                listener2.report(list);
            }
            listener2.onAfterEndReport();
        });
    }

    public void reset() {
        this.myChangeLists.clear();
        this.myFilteringStrategy.resetFilterBase();
        this.myState = TreeState.createOn((JTree)((Object)this.myChangesTree), (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myChangesTree.getModel().getRoot()));
        this.updateModel();
    }

    public void append(@NotNull List<? extends CommittedChangeList> list) {
        TreeState state = this.myChangeLists.isEmpty() && this.myState != null ? this.myState : TreeState.createOn((JTree)((Object)this.myChangesTree), (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myChangesTree.getModel().getRoot()));
        state.setScrollToSelection(false);
        this.myChangeLists.addAll(list);
        this.myFilteringStrategy.appendFilterBase(list);
        this.myChangesTree.setModel(this.buildTreeModel(this.myFilteringStrategy.filterChangeLists(this.myChangeLists)));
        state.applyTo((JTree)((Object)this.myChangesTree), this.myChangesTree.getModel().getRoot());
        TreeUtil.expandAll((JTree)((Object)this.myChangesTree));
        ((CommittedChangesReloadListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, ITEMS_RELOADED)).itemsReloaded();
    }

    public void setLoading(boolean value) {
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> this.myChangesTree.setPaintBusy(value), (ModalityState)ModalityState.NON_MODAL, (Project)this.myProject);
    }

    private static class MyRepositoryChangesViewer
    extends CommittedChangesBrowser {
        private final JComponent myHeaderPanel = new JPanel();

        MyRepositoryChangesViewer(Project project) {
            super(project);
        }

        @Override
        @Nullable
        protected JComponent createHeaderPanel() {
            return this.myHeaderPanel;
        }

        @Override
        @NotNull
        protected Border createViewerBorder() {
            return RIGHT_BORDER;
        }

        public void syncSizeWithToolbar(@NotNull JComponent toolbar) {
            this.myHeaderPanel.setPreferredSize(new Dimension(0, toolbar.getPreferredSize().height));
        }
    }

    public static interface CommittedChangesReloadListener {
        public void itemsReloaded();

        public void emptyRefresh();
    }

    private class ChangesBrowserTree
    extends Tree
    implements DataProvider {
        ChangesBrowserTree() {
            super(CommittedChangesTreeBrowser.this.buildTreeModel(CommittedChangesTreeBrowser.this.myFilteringStrategy.filterChangeLists(CommittedChangesTreeBrowser.this.myChangeLists)));
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return CommittedChangesTreeBrowser.this.myCopyProvider;
            }
            if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                return CommittedChangesTreeBrowser.this.myTreeExpander;
            }
            if (VcsDataKeys.SELECTED_CHANGES.is(dataId) || VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId) || CommittedChangesBrowserUseCase.DATA_KEY.is(dataId)) {
                return CommittedChangesTreeBrowser.this.myDetailsView.getData(dataId);
            }
            return null;
        }

        public void invalidateNodeSizes() {
            TreeUtil.invalidateCacheAndRepaint((TreeUI)this.getUI());
        }
    }

    private class FilterChangeListener
    implements ChangeListener {
        private FilterChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                CommittedChangesTreeBrowser.this.updateModel();
            } else {
                ApplicationManager.getApplication().invokeLater(() -> CommittedChangesTreeBrowser.this.updateModel());
            }
        }
    }

    public static class MoreLauncher
    implements Runnable {
        private final Project myProject;
        private final CommittedChangeList myList;

        MoreLauncher(Project project, CommittedChangeList list) {
            this.myProject = project;
            this.myList = list;
        }

        @Override
        public void run() {
            ChangeListDetailsAction.showDetailsPopup(this.myProject, this.myList);
        }
    }
}

