/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CommittedChangesBrowser
extends SimpleChangesBrowser {
    private CommittedChangesBrowserUseCase myUseCase;

    public CommittedChangesBrowser(@NotNull Project project) {
        super(project, false, false);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        return ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.RepositoryChangesBrowserToolbar")});
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        return ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.RepositoryChangesBrowserMenu")});
    }

    public void setUseCase(CommittedChangesBrowserUseCase useCase) {
        this.myUseCase = useCase;
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (CommittedChangesBrowserUseCase.DATA_KEY.is(dataId)) {
            return this.myUseCase;
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            Set abstractVcs = ChangesUtil.getAffectedVcses(this.getSelectedChanges(), (Project)this.myProject);
            if (abstractVcs.size() == 1) {
                return ((AbstractVcs)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)abstractVcs))).getKeyInstanceMethod();
            }
            return null;
        }
        return super.getData(dataId);
    }
}

