/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffChangeUi;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalTrackerDiffUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedLocalChangeListDiffViewer
extends UnifiedDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest myLocalRequest;
    private final boolean myAllowExcludeChangesFromCommit;
    private final LocalTrackerDiffUtil.LocalTrackerActionProvider myTrackerActionProvider;
    private LocalTrackerDiffUtil.ExcludeAllCheckboxPanel myExcludeAllCheckboxPanel;

    public UnifiedLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        super(context, (DiffRequest)localRequest.getRequest());
        this.myLocalRequest = localRequest;
        this.myAllowExcludeChangesFromCommit = DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder[])new UserDataHolder[]{context});
        this.myTrackerActionProvider = new MyLocalTrackerActionProvider(this, localRequest, this.myAllowExcludeChangesFromCommit);
        this.myExcludeAllCheckboxPanel.init(this.myLocalRequest, this.myAllowExcludeChangesFromCommit);
        LocalTrackerDiffUtil.installTrackerListener((DiffViewerBase)this, this.myLocalRequest);
    }

    @Nullable
    protected JComponent createTitles() {
        JComponent titles = super.createTitles();
        this.myExcludeAllCheckboxPanel = new LocalTrackerDiffUtil.ExcludeAllCheckboxPanel((DiffViewerBase)this, this.getEditor());
        BorderLayoutPanel titleWithCheckbox = JBUI.Panels.simplePanel();
        if (titles != null) {
            titleWithCheckbox.addToCenter((Component)titles);
        }
        titleWithCheckbox.addToLeft((Component)this.myExcludeAllCheckboxPanel);
        return titleWithCheckbox;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(super.createEditorPopupActions());
        group.addAll(LocalTrackerDiffUtil.createTrackerActions(this.myTrackerActionProvider));
        return group;
    }

    @NotNull
    protected UnifiedDiffChangeUi createUi(@NotNull UnifiedDiffChange change) {
        if (change instanceof MyUnifiedDiffChange) {
            return new MyUnifiedDiffChangeUi(this, (MyUnifiedDiffChange)change);
        }
        return super.createUi(change);
    }

    @NotNull
    private Runnable superComputeDifferences(@NotNull ProgressIndicator indicator) {
        return super.computeDifferences(indicator);
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        Document document1 = this.getContent1().getDocument();
        Document document2 = this.getContent2().getDocument();
        return LocalTrackerDiffUtil.computeDifferences(this.myLocalRequest.getLineStatusTracker(), document1, document2, this.myLocalRequest.getChangelistId(), (TwosideTextDiffProvider)this.myTextDiffProvider, indicator, new MyLocalTrackerDiffHandler(document1, document2, indicator));
    }

    protected void onAfterRediff() {
        super.onAfterRediff();
        this.myExcludeAllCheckboxPanel.refresh();
    }

    private static class MyLocalTrackerActionProvider
    extends LocalTrackerDiffUtil.LocalTrackerActionProvider {
        @NotNull
        private final UnifiedLocalChangeListDiffViewer myViewer;

        private MyLocalTrackerActionProvider(@NotNull UnifiedLocalChangeListDiffViewer viewer, @NotNull LocalChangeListDiffRequest localRequest, boolean allowExcludeChangesFromCommit) {
            super((DiffViewerBase)viewer, localRequest, allowExcludeChangesFromCommit);
            this.myViewer = viewer;
        }

        @Override
        @Nullable
        public List<LocalTrackerDiffUtil.LocalTrackerChange> getSelectedTrackerChanges(@NotNull AnActionEvent e) {
            if (!this.myViewer.isContentGood()) {
                return null;
            }
            return StreamEx.of((Collection)this.myViewer.getSelectedChanges()).select(MyUnifiedDiffChange.class).map(it -> new LocalTrackerDiffUtil.LocalTrackerChange(this.myViewer.transferLineFromOneside(Side.RIGHT, it.getLine1()), this.myViewer.transferLineFromOneside(Side.RIGHT, it.getLine2()), ((MyUnifiedDiffChange)it).myChangelistId, ((MyUnifiedDiffChange)it).myIsExcludedFromCommit)).toList();
        }
    }

    private static class MyUnifiedDiffChangeUi
    extends UnifiedDiffChangeUi {
        private MyUnifiedDiffChangeUi(@NotNull UnifiedLocalChangeListDiffViewer viewer, @NotNull MyUnifiedDiffChange change) {
            super((UnifiedDiffViewer)viewer, (UnifiedDiffChange)change);
        }

        @NotNull
        private UnifiedLocalChangeListDiffViewer getViewer() {
            return (UnifiedLocalChangeListDiffViewer)this.myViewer;
        }

        @NotNull
        private MyUnifiedDiffChange getChange() {
            return (MyUnifiedDiffChange)this.myChange;
        }

        protected void doInstallActionHighlighters() {
            if (this.getViewer().myAllowExcludeChangesFromCommit) {
                ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createExcludeOperation());
            }
            super.doInstallActionHighlighters();
        }

        @Nullable
        private DiffGutterOperation createExcludeOperation() {
            if (!this.getChange().isFromActiveChangelist()) {
                return null;
            }
            return this.createOperation(() -> {
                final boolean isExcludedFromCommit = this.getChange().isExcludedFromCommit();
                Icon icon2 = isExcludedFromCommit ? AllIcons.Diff.GutterCheckBox : AllIcons.Diff.GutterCheckBoxSelected;
                return new DiffGutterRenderer(icon2, DiffBundle.message((String)"action.presentation.diff.include.into.commit.text", (Object[])new Object[0])){

                    protected void handleMouseClick() {
                        if (!this.getViewer().isContentGood()) {
                            return;
                        }
                        int line = myViewer.transferLineFromOneside(Side.RIGHT, myChange.getLine1());
                        LocalTrackerDiffUtil.toggleRangeAtLine(this.getViewer().myTrackerActionProvider, line, isExcludedFromCommit);
                    }
                };
            });
        }
    }

    private static class MyUnifiedDiffChange
    extends UnifiedDiffChange {
        @NotNull
        private final String myChangelistId;
        private final boolean myIsFromActiveChangelist;
        private final boolean myIsExcludedFromCommit;

        private MyUnifiedDiffChange(int blockStart, int insertedStart, int blockEnd, @NotNull LineFragment lineFragment, boolean isExcluded, boolean isSkipped, @NotNull String changelistId, boolean isFromActiveChangelist, boolean isExcludedFromCommit) {
            super(blockStart, insertedStart, blockEnd, lineFragment, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsFromActiveChangelist = isFromActiveChangelist;
            this.myIsExcludedFromCommit = isExcludedFromCommit;
        }

        @NotNull
        public String getChangelistId() {
            return this.myChangelistId;
        }

        public boolean isFromActiveChangelist() {
            return this.myIsFromActiveChangelist;
        }

        public boolean isExcludedFromCommit() {
            return this.myIsExcludedFromCommit;
        }
    }

    private class MyUnifiedFragmentBuilder
    extends UnifiedFragmentBuilder {
        @NotNull
        private final List<LocalTrackerDiffUtil.LineFragmentData> myFragmentsData;

        MyUnifiedFragmentBuilder(@NotNull List<? extends LineFragment> fragments, @NotNull List<LocalTrackerDiffUtil.LineFragmentData> fragmentsData, @NotNull Document document1, Document document2) {
            super(fragments, document1, document2, UnifiedLocalChangeListDiffViewer.this.myMasterSide);
            this.myFragmentsData = fragmentsData;
        }

        @NotNull
        protected UnifiedDiffChange createDiffChange(int blockStart, int insertedStart, int blockEnd, int fragmentIndex) {
            LineFragment fragment = (LineFragment)this.myFragments.get(fragmentIndex);
            LocalTrackerDiffUtil.LineFragmentData data = this.myFragmentsData.get(fragmentIndex);
            boolean isSkipped = data.isSkipped();
            boolean isExcluded = data.isExcluded(UnifiedLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit);
            return new MyUnifiedDiffChange(blockStart, insertedStart, blockEnd, fragment, isExcluded, isSkipped, data.getChangelistId(), data.isFromActiveChangelist(), data.isExcludedFromCommit());
        }
    }

    private class MyLocalTrackerDiffHandler
    implements LocalTrackerDiffUtil.LocalTrackerDiffHandler {
        @NotNull
        private final Document myDocument1;
        @NotNull
        private final Document myDocument2;
        @NotNull
        private final ProgressIndicator myIndicator;

        private MyLocalTrackerDiffHandler(@NotNull Document document1, @NotNull Document document2, ProgressIndicator indicator) {
            this.myDocument1 = document1;
            this.myDocument2 = document2;
            this.myIndicator = indicator;
        }

        @Override
        @NotNull
        public Runnable done(boolean isContentsEqual, CharSequence @NotNull [] texts, @NotNull List<? extends LineFragment> fragments, @NotNull List<LocalTrackerDiffUtil.LineFragmentData> fragmentsData) {
            UnifiedFragmentBuilder builder = (UnifiedFragmentBuilder)ReadAction.compute(() -> {
                this.myIndicator.checkCanceled();
                return new MyUnifiedFragmentBuilder(fragments, fragmentsData, this.myDocument1, this.myDocument2).exec();
            });
            return UnifiedLocalChangeListDiffViewer.this.apply(builder, texts, this.myIndicator);
        }

        @Override
        @NotNull
        public Runnable retryLater() {
            UnifiedLocalChangeListDiffViewer.this.scheduleRediff();
            throw new ProcessCanceledException();
        }

        @Override
        @NotNull
        public Runnable fallback() {
            return UnifiedLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
        }

        @Override
        @NotNull
        public Runnable fallbackWithProgress() {
            Runnable callback2 = UnifiedLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            return () -> {
                callback2.run();
                UnifiedLocalChangeListDiffViewer.this.getStatusPanel().setBusy(true);
            };
        }

        @Override
        @NotNull
        public Runnable error() {
            return UnifiedLocalChangeListDiffViewer.this.applyErrorNotification();
        }
    }
}

