/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.VcsActionUsagesCollectorKt;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefreshAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        RefreshAction.doRefresh(project);
    }

    public static void doRefresh(Project project) {
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RefreshAction.invokeCustomRefreshes(project);
        VirtualFileManager.getInstance().asyncRefresh(() -> {
            if (!project.isDisposed()) {
                RefreshAction.performRefreshAndTrackChanges(project);
            }
        });
    }

    private static void invokeCustomRefreshes(@NotNull Project project) {
        ChangesViewRefresher[] extensions;
        for (ChangesViewRefresher refresher : extensions = (ChangesViewRefresher[])ChangesViewRefresher.EP_NAME.getExtensions((AreaInstance)project)) {
            refresher.refresh(project);
        }
    }

    private static void performRefreshAndTrackChanges(Project project) {
        ChangeListManagerImpl changeListManager = (ChangeListManagerImpl)ChangeListManager.getInstance((Project)project);
        Collection<Change> changesBeforeUpdate = changeListManager.getAllChanges();
        List<FilePath> unversionedBefore = changeListManager.getUnversionedFilesPaths();
        boolean wasUpdatingBefore = changeListManager.isInUpdate();
        VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
        changeListManager.invokeAfterUpdate(() -> {
            Collection<Change> changesAfterUpdate = changeListManager.getAllChanges();
            List<FilePath> unversionedAfter = changeListManager.getUnversionedFilesPaths();
            VcsActionUsagesCollectorKt.logRefreshActionPerformed(changesBeforeUpdate, changesAfterUpdate, unversionedBefore, unversionedAfter, wasUpdatingBefore);
        }, InvokeAfterUpdateMode.SILENT, "Refresh Action", ModalityState.current());
    }
}

