/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EditAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        List files = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        assert (project != null);
        assert (files != null);
        EditAction.editFilesAndShowErrors(project, files);
    }

    public static void editFilesAndShowErrors(@NotNull Project project, @NotNull List<? extends VirtualFile> files) {
        ArrayList exceptions = new ArrayList();
        EditAction.editFiles(project, files, exceptions);
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"edit.errors", (Object[])new Object[0]));
        }
    }

    public static void editFiles(@NotNull Project project, @NotNull List<? extends VirtualFile> files, List<? super VcsException> exceptions) {
        ChangesUtil.processVirtualFilesByVcs((Project)project, files, (vcs, items) -> {
            EditFileProvider provider = vcs.getEditFileProvider();
            if (provider == null) {
                return;
            }
            try {
                provider.editFiles(VfsUtilCore.toVirtualFileArray((Collection)items));
            }
            catch (VcsException e1) {
                exceptions.add(e1);
            }
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
            FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
            for (VirtualFile file : items) {
                vcsDirtyScopeManager.fileDirty(file);
                fileStatusManager.fileStatusChanged(file);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        List files = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        boolean enabled = files != null && !files.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }
}

