/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.SpecificFilesViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnversionedViewDialog
extends SpecificFilesViewDialog {
    private static final String TOOLBAR_GROUP = "Unversioned.Files.Dialog";
    private static final String POPUP_GROUP = "Unversioned.Files.Dialog.Popup";

    public UnversionedViewDialog(@NotNull Project project) {
        this(project, ChangeListManagerImpl.getInstanceImpl(project).getUnversionedFilesPaths());
    }

    public UnversionedViewDialog(@NotNull Project project, @NotNull List<FilePath> filePaths) {
        super(project, VcsBundle.message((String)"dialog.title.unversioned.files", (Object[])new Object[0]), ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY, filePaths);
    }

    @Override
    protected void addCustomActions(@NotNull DefaultActionGroup group) {
        group.add((AnAction)UnversionedViewDialog.getUnversionedToolbarGroup());
        this.myView.installPopupHandler(UnversionedViewDialog.registerUnversionedPopupGroup((JComponent)((Object)this.myView)));
    }

    @NotNull
    public static ActionGroup getUnversionedToolbarGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction(TOOLBAR_GROUP);
    }

    @NotNull
    public static ActionGroup getUnversionedPopupGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction(POPUP_GROUP);
    }

    @NotNull
    public static ActionGroup registerUnversionedPopupGroup(@NotNull JComponent component) {
        ActionGroup popupGroup = UnversionedViewDialog.getUnversionedPopupGroup();
        ActionUtil.recursiveRegisterShortcutSet((ActionGroup)popupGroup, (JComponent)component, null);
        return popupGroup;
    }

    @Override
    @NotNull
    protected List<FilePath> getFiles() {
        return ((ChangeListManagerImpl)this.myChangeListManager).getUnversionedFilesPaths();
    }
}

