/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.google.common.collect.Iterables;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchedFileHolder
implements FileHolder {
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final TreeMap<VirtualFile, Pair<Boolean, String>> myMap;

    public SwitchedFileHolder(Project project) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myMap = new TreeMap(FilePathComparator.getInstance());
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    @Override
    public synchronized SwitchedFileHolder copy() {
        SwitchedFileHolder copyHolder = new SwitchedFileHolder(this.myProject);
        copyHolder.myMap.putAll(this.myMap);
        return copyHolder;
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope2) {
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<VirtualFile> iterator = this.myMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (!this.isFileDirty((VcsDirtyScope)scope2, file)) continue;
            iterator.remove();
        }
    }

    private boolean isFileDirty(VcsDirtyScope scope2, VirtualFile file) {
        if (scope2 == null) {
            return true;
        }
        if (this.fileDropped(file)) {
            return true;
        }
        return scope2.belongsTo(VcsUtil.getFilePath((VirtualFile)file));
    }

    private boolean fileDropped(VirtualFile file) {
        return !file.isValid() || this.myVcsManager.getVcsFor(file) == null;
    }

    public Map<VirtualFile, String> getFilesMapCopy() {
        HashMap<VirtualFile, String> result2 = new HashMap<VirtualFile, String>();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.put(vf, (String)this.myMap.get(vf).getSecond());
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @NotNull
    public Collection<VirtualFile> values() {
        return this.myMap.keySet();
    }

    public void addFile(VirtualFile file, String branch, boolean recursive) {
        this.myMap.put(file, (Pair<Boolean, String>)new Pair((Object)recursive, (Object)branch));
    }

    public void removeFile(@NotNull VirtualFile file) {
        this.myMap.remove(file);
    }

    public synchronized MultiMap<String, VirtualFile> getBranchToFileMap() {
        MultiMap result2 = new MultiMap();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.putValue(this.myMap.get(vf).getSecond(), (Object)vf);
        }
        return result2;
    }

    public synchronized boolean containsFile(@NotNull VirtualFile file) {
        VirtualFile floor = this.myMap.floorKey(file);
        if (floor == null) {
            return false;
        }
        NavigableMap<VirtualFile, Pair<Boolean, String>> floorMap = this.myMap.headMap(floor, true);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)false)) continue;
            Pair value = (Pair)floorMap.get(parent);
            return parent.equals(file) || (Boolean)value.getFirst() != false;
        }
        return false;
    }

    @Nullable
    public String getBranchForFile(VirtualFile file) {
        VirtualFile floor = this.myMap.floorKey(file);
        if (floor == null) {
            return null;
        }
        SortedMap<VirtualFile, Pair<Boolean, String>> floorMap = this.myMap.headMap(floor);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)false)) continue;
            return (String)((Pair)floorMap.get(parent)).getSecond();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchedFileHolder that = (SwitchedFileHolder)o;
        return Iterables.elementsEqual(this.myMap.entrySet(), that.myMap.entrySet());
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }
}

