/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesOnServerTracker;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RemoteRevisionsStateCache
implements ChangesOnServerTracker {
    private static final long DISCRETE = 3600000L;
    @NotNull
    private final Map<String, Pair<Boolean, VcsRoot>> myChanged = new HashMap<String, Pair<Boolean, VcsRoot>>();
    @NotNull
    private final MultiMap<VcsRoot, String> myQueries = new MultiMap();
    @NotNull
    private final Map<VcsRoot, Long> myTs = new HashMap<VcsRoot, Long>();
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final Project myProject;

    RemoteRevisionsStateCache(@NotNull Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Collection<String> paths) {
        Object object = this.myLock;
        synchronized (object) {
            for (String path2 : paths) {
                this.myChanged.remove(path2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpToDate(@NotNull Change change, @NotNull AbstractVcs vcs) {
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return true;
        }
        List files = ChangesUtil.getIoFilesFromChanges(Collections.singletonList(change));
        Object object = this.myLock;
        synchronized (object) {
            for (File file : files) {
                String path2 = file.getAbsolutePath();
                Pair<Boolean, VcsRoot> data = this.myChanged.get(path2);
                if (data == null || !Boolean.TRUE.equals(data.getFirst())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeUpdated(@NotNull String path2, @NotNull AbstractVcs vcs) {
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return;
        }
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)VcsUtil.getFilePath((String)path2, (boolean)false));
        if (root == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueries.putValue((Object)new VcsRoot(vcs, root), (Object)path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeRemoved(@NotNull String path2, @NotNull AbstractVcs vcs) {
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return;
        }
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)VcsUtil.getFilePath((String)path2, (boolean)false));
        if (root == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            VcsRoot key = new VcsRoot(vcs, root);
            if (this.myQueries.containsKey((Object)key)) {
                this.myQueries.remove((Object)key, (Object)path2);
            }
            this.myChanged.remove(path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directoryMappingChanged() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChanged.clear();
            this.myTs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStep() {
        MultiMap dirty = new MultiMap();
        int interval = VcsConfiguration.getInstance((Project)this.myProject).CHANGED_ON_SERVER_INTERVAL;
        long oldPoint = System.currentTimeMillis() - (interval > 0 ? (long)interval * 60000L : 3600000L);
        Object object = this.myLock;
        synchronized (object) {
            for (Object root : this.myQueries.keySet()) {
                Collection object2 = this.myQueries.get(root);
                for (String s : object2) {
                    dirty.putValue(root, (Object)s);
                }
            }
            this.myQueries.clear();
            HashSet roots = new HashSet();
            for (Map.Entry entry : this.myTs.entrySet()) {
                Long ts;
                if (!dirty.get(entry.getKey()).isEmpty() || (ts = (Long)entry.getValue()) != null && oldPoint <= ts) continue;
                roots.add(entry.getKey());
            }
            for (Map.Entry entry : this.myChanged.entrySet()) {
                VcsRoot vcsRoot = (VcsRoot)((Pair)entry.getValue()).getSecond();
                if (dirty.get((Object)vcsRoot).isEmpty() && !roots.contains(vcsRoot)) continue;
                dirty.putValue((Object)vcsRoot, entry.getKey());
            }
        }
        if (dirty.isEmpty()) {
            return false;
        }
        HashMap<String, Pair> results = new HashMap<String, Pair>();
        for (VcsRoot vcsRoot : dirty.keySet()) {
            TreeDiffProvider treeDiffProvider;
            if (!vcsRoot.getVcs().isVcsBackgroundOperationsAllowed(vcsRoot.getPath()) || (treeDiffProvider = vcsRoot.getVcs().getTreeDiffProvider()) == null) continue;
            Collection paths = dirty.get((Object)vcsRoot);
            Collection remotelyChanged = treeDiffProvider.getRemotelyChanged(vcsRoot.getPath(), paths);
            for (String path2 : paths) {
                results.put(path2, new Pair((Object)remotelyChanged.contains(path2), (Object)vcsRoot));
            }
        }
        long curTime = System.currentTimeMillis();
        Object object2 = this.myLock;
        synchronized (object2) {
            this.myChanged.putAll(results);
            for (VcsRoot vcsRoot : dirty.keySet()) {
                this.myTs.put(vcsRoot, curTime);
            }
        }
        return true;
    }

    private static boolean isSupportedFor(@NotNull AbstractVcs vcs) {
        return vcs.getTreeDiffProvider() != null;
    }
}

