/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ControlledCycle;
import com.intellij.openapi.vcs.changes.RemoteRevisionsNumbersCache;
import com.intellij.openapi.vcs.changes.RemoteRevisionsStateCache;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class RemoteRevisionsCache
implements VcsListener {
    private static final Logger LOG = Logger.getInstance(RemoteRevisionsCache.class);
    public static final Topic<Runnable> REMOTE_VERSION_CHANGED = new Topic("REMOTE_VERSION_CHANGED", Runnable.class);
    public static final int DEFAULT_REFRESH_INTERVAL = 180000;
    private final RemoteRevisionsNumbersCache myRemoteRevisionsNumbersCache;
    private final RemoteRevisionsStateCache myRemoteRevisionsStateCache;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final RemoteStatusChangeNodeDecorator myChangeDecorator;
    private final Project myProject;
    private final ControlledCycle myControlledCycle;

    public static RemoteRevisionsCache getInstance(Project project) {
        return (RemoteRevisionsCache)ServiceManager.getService((Project)project, RemoteRevisionsCache.class);
    }

    private RemoteRevisionsCache(Project project) {
        this.myProject = project;
        this.myRemoteRevisionsNumbersCache = new RemoteRevisionsNumbersCache(this.myProject);
        this.myRemoteRevisionsStateCache = new RemoteRevisionsStateCache(this.myProject);
        this.myChangeDecorator = new RemoteStatusChangeNodeDecorator(this);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myControlledCycle = new ControlledCycle(project, (Getter<Boolean>)((Getter)() -> {
            boolean shouldBeDone;
            boolean bl = shouldBeDone = vcsConfiguration.isChangedOnServerEnabled() && this.myVcsManager.hasActiveVcss();
            if (shouldBeDone) {
                boolean somethingChanged = this.myRemoteRevisionsNumbersCache.updateStep();
                if (somethingChanged |= this.myRemoteRevisionsStateCache.updateStep()) {
                    ((Runnable)BackgroundTaskUtil.syncPublisher((Project)this.myProject, REMOTE_VERSION_CHANGED)).run();
                }
            }
            return shouldBeDone;
        }), "Finishing \"changed on server\" update", 180000);
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)this);
        if (!this.myProject.isDefault() && vcsConfiguration.isChangedOnServerEnabled()) {
            this.myVcsManager.runAfterInitialization(() -> {
                if (!this.myVcsManager.hasActiveVcss() || !vcsConfiguration.isChangedOnServerEnabled()) {
                    return;
                }
                this.myControlledCycle.startIfNotStarted();
            });
        }
    }

    public void updateAutomaticRefreshAlarmState(boolean remoteCacheStateChanged) {
        this.manageAlarm();
    }

    private void manageAlarm() {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (!this.myProject.isDefault() && this.myVcsManager.hasActiveVcss() && vcsConfiguration.isChangedOnServerEnabled()) {
            this.myControlledCycle.startIfNotStarted();
        } else {
            this.myControlledCycle.stop();
        }
    }

    public void directoryMappingChanged() {
        if (!VcsConfiguration.getInstance((Project)this.myProject).isChangedOnServerEnabled()) {
            this.manageAlarm();
        } else {
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> {
                try {
                    this.myRemoteRevisionsNumbersCache.directoryMappingChanged();
                    this.myRemoteRevisionsStateCache.directoryMappingChanged();
                    this.manageAlarm();
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            });
        }
    }

    public void changeUpdated(@NotNull String path2, @NotNull AbstractVcs vcs) {
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.changeUpdated(path2, vcs);
        } else {
            this.myRemoteRevisionsNumbersCache.changeUpdated(path2, vcs);
        }
    }

    public void invalidate(UpdatedFiles updatedFiles) {
        ArrayList<String> newForTree = new ArrayList<String>();
        ArrayList<String> newForUsual = new ArrayList<String>();
        UpdateFilesHelper.iterateAffectedFiles(updatedFiles, (Consumer<? super Couple<String>>)((Consumer)pair -> {
            AbstractVcs vcs = this.myVcsManager.findVcsByName((String)pair.getSecond());
            if (vcs == null) {
                return;
            }
            if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
                newForTree.add((String)pair.getFirst());
            } else {
                newForUsual.add((String)pair.getFirst());
            }
        }));
        this.myRemoteRevisionsStateCache.invalidate(newForTree);
        this.myRemoteRevisionsNumbersCache.invalidate(newForUsual);
    }

    public void changeRemoved(@NotNull String path2, @NotNull AbstractVcs vcs) {
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.changeRemoved(path2, vcs);
        } else {
            this.myRemoteRevisionsNumbersCache.changeRemoved(path2, vcs);
        }
    }

    public boolean isUpToDate(@NotNull Change change) {
        if (this.myProject.isDisposed()) {
            return true;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)this.myProject);
        if (vcs == null) {
            return true;
        }
        RemoteDifferenceStrategy strategy = vcs.getRemoteDifferenceStrategy();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)strategy)) {
            return this.myRemoteRevisionsStateCache.isUpToDate(change, vcs);
        }
        return this.myRemoteRevisionsNumbersCache.isUpToDate(change, vcs);
    }

    @NotNull
    public RemoteStatusChangeNodeDecorator getChangesNodeDecorator() {
        return this.myChangeDecorator;
    }
}

