/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.DiffPreviewProvider;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PreviewDiffVirtualFile
extends DiffVirtualFile {
    @NotNull
    private final DiffPreviewProvider myProvider;

    public PreviewDiffVirtualFile(@NotNull DiffPreviewProvider provider) {
        super(provider.getEditorTabName());
        this.myProvider = provider;
    }

    public boolean isValid() {
        Object owner = this.myProvider.getOwner();
        if (!(owner instanceof Disposable)) {
            return true;
        }
        return !Disposer.isDisposed((Disposable)((Disposable)owner));
    }

    @NotNull
    public DiffRequestProcessor createProcessor(@NotNull Project project) {
        return this.myProvider.createDiffRequestProcessor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PreviewDiffVirtualFile file = (PreviewDiffVirtualFile)((Object)o);
        return this.myProvider.getOwner().equals(file.myProvider.getOwner());
    }

    public int hashCode() {
        return Objects.hash(this.myProvider.getOwner());
    }

    @NotNull
    public DiffPreviewProvider getProvider() {
        return this.myProvider;
    }
}

