/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangeListImpl
extends LocalChangeList {
    private static final Logger LOG = Logger.getInstance(ChangeList.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myId;
    @NotNull
    private final String myName;
    @NotNull
    private final String myComment;
    @NotNull
    private final Set<Change> myChanges;
    @Nullable
    private final ChangeListData myData;
    private final boolean myIsDefault;
    private final boolean myIsReadOnly;

    @NotNull
    public static LocalChangeListImpl createEmptyChangeListImpl(@NotNull Project project, @NotNull String name, @Nullable String id) {
        return new Builder(project, name).setId(id).build();
    }

    @NotNull
    public static String generateChangelistId() {
        return UUID.randomUUID().toString();
    }

    private LocalChangeListImpl(@NotNull Project project, @NotNull String id, @NotNull String name, @NotNull String comment, @NotNull Set<Change> changes, @Nullable ChangeListData data, boolean isDefault, boolean isReadOnly) {
        this.myProject = project;
        this.myId = id;
        this.myName = name;
        this.myComment = comment;
        this.myChanges = changes;
        this.myData = data;
        this.myIsDefault = isDefault;
        this.myIsReadOnly = isReadOnly;
    }

    private LocalChangeListImpl(@NotNull LocalChangeListImpl origin) {
        this.myProject = origin.myProject;
        this.myId = origin.myId;
        this.myName = origin.myName;
        this.myComment = origin.myComment;
        this.myChanges = origin.myChanges;
        this.myData = origin.myData;
        this.myIsDefault = origin.myIsDefault;
        this.myIsReadOnly = origin.myIsReadOnly;
    }

    @NotNull
    public Set<Change> getChanges() {
        return Collections.unmodifiableSet(this.myChanges);
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getComment() {
        return this.myComment;
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    @Nullable
    public ChangeListData getData() {
        return this.myData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LocalChangeListImpl list = (LocalChangeListImpl)((Object)o);
        return this.myName.equals(list.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName;
    }

    public LocalChangeListImpl copy() {
        return this;
    }

    public void setName(@NotNull String name) {
        ChangeListManager.getInstance((Project)this.myProject).editName(this.myName, name);
    }

    public void setComment(@Nullable String comment) {
        ChangeListManager.getInstance((Project)this.myProject).editComment(this.myName, comment);
    }

    public void setReadOnly(boolean isReadOnly) {
        ChangeListManager.getInstance((Project)this.myProject).setReadOnly(this.myName, isReadOnly);
    }

    public static class Builder {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myName;
        @Nullable
        private String myId;
        @NotNull
        private String myComment = "";
        @NotNull
        private Set<Change> myChanges = new HashSet<Change>();
        @Nullable
        private ChangeListData myData = null;
        private boolean myIsDefault = false;
        private boolean myIsReadOnly = false;

        public Builder(@NotNull Project project, @NotNull String name) {
            if (StringUtil.isEmptyOrSpaces((String)name) && Registry.is((String)"vcs.log.empty.change.list.creation")) {
                LOG.info("Creating a changelist with empty name");
            }
            this.myProject = project;
            this.myName = name;
        }

        public Builder(@NotNull LocalChangeListImpl list) {
            this.myProject = list.myProject;
            this.myId = list.myId;
            this.myName = list.myName;
            this.myComment = list.myComment;
            this.myChanges = list.myChanges;
            this.myData = list.myData;
            this.myIsDefault = list.myIsDefault;
            this.myIsReadOnly = list.myIsReadOnly;
        }

        public Builder setId(@Nullable String value) {
            this.myId = value;
            return this;
        }

        public Builder setComment(@NotNull String value) {
            this.myComment = value;
            return this;
        }

        public Builder setChanges(@NotNull Collection<? extends Change> changes) {
            this.myChanges.clear();
            this.myChanges.addAll(changes);
            return this;
        }

        public Builder setChangesCollection(@NotNull Set<Change> changes) {
            this.myChanges = changes;
            return this;
        }

        public Builder setData(@Nullable ChangeListData value) {
            this.myData = value;
            return this;
        }

        public Builder setDefault(boolean value) {
            this.myIsDefault = value;
            return this;
        }

        public Builder setReadOnly(boolean value) {
            this.myIsReadOnly = value;
            return this;
        }

        @NotNull
        public LocalChangeListImpl build() {
            String id = this.myId != null ? this.myId : LocalChangeListImpl.generateChangelistId();
            return new LocalChangeListImpl(this.myProject, id, this.myName, this.myComment, this.myChanges, this.myData, this.myIsDefault, this.myIsReadOnly);
        }
    }
}

