/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Alarm;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ControlledCycle {
    private static final Logger LOG = Logger.getInstance(ControlledCycle.class);
    private final Alarm mySimpleAlarm;
    private final int myRefreshInterval;
    private final Runnable myRunnable;
    private final AtomicBoolean myActive;

    public ControlledCycle(final @NotNull Project project, final Getter<Boolean> callback2, @NotNull String name, int refreshInterval) {
        this.myRefreshInterval = refreshInterval;
        this.myActive = new AtomicBoolean(false);
        this.myRunnable = new Runnable(){
            boolean shouldBeContinued = true;

            @Override
            public void run() {
                if (!ControlledCycle.this.myActive.get() || project.isDisposed()) {
                    return;
                }
                try {
                    this.shouldBeContinued = (Boolean)callback2.get();
                }
                catch (ProcessCanceledException e) {
                    return;
                }
                catch (RuntimeException e) {
                    LOG.info((Throwable)e);
                }
                if (!this.shouldBeContinued) {
                    ControlledCycle.this.myActive.set(false);
                } else {
                    ControlledCycle.this.mySimpleAlarm.addRequest(ControlledCycle.this.myRunnable, ControlledCycle.this.myRefreshInterval);
                }
            }
        };
        this.mySimpleAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
    }

    public void startIfNotStarted() {
        if (this.myActive.compareAndSet(false, true)) {
            this.mySimpleAlarm.addRequest(this.myRunnable, this.myRefreshInterval);
        }
    }

    public void stop() {
        this.myActive.set(false);
    }
}

