/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsPreviewPanel
implements PreviewPanel {
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final EditorEx myEditor;

    VcsPreviewPanel() {
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        this.myEditor = (EditorEx)EditorFactory.getInstance().createViewer((Document)document);
        this.myEditor.getGutterComponentEx().setForceShowRightFreePaintersArea(true);
        this.myEditor.getSettings().setFoldingOutlineShown(true);
    }

    public void disposeUIResources() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    public Component getPanel() {
        return this.myEditor.getComponent();
    }

    public void blinkSelectedHighlightType(Object selected) {
    }

    public void updateView() {
        EditorColorsScheme colorsScheme = this.myEditor.getColorsScheme();
        StringBuilder sb = new StringBuilder();
        sb.append("Deleted line below\n\nModified line\n\nAdded line\n\nLine with modified whitespaces\n\nAdded line\nLine with modified whitespaces and deletion after\n\nDeleted ignored line below\n\nModified ignored line\n\nAdded ignored line\n\n");
        int additionalLines = Math.max(0, AnnotationsSettings.getInstance().getOrderedColors(colorsScheme).size() - StringUtil.countNewLines((CharSequence)sb));
        sb.append(StringUtil.repeat((String)"\n", (int)additionalLines));
        this.myEditor.getDocument().setText((CharSequence)sb);
        this.myEditor.getMarkupModel().removeAllHighlighters();
        this.myEditor.getGutterComponentEx().closeAllAnnotations();
        this.addHighlighter(new Range(1, 1, 0, 1), false, EditorColors.DELETED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(2, 1), false, EditorColors.MODIFIED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(4, 2), false, EditorColors.ADDED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(6, 0), false, EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(8, 2, 0, 3), false, EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        this.addHighlighter(new Range(12, 12, 0, 1), true, EditorColors.IGNORED_DELETED_LINES_BORDER_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(13, 1), true, EditorColors.IGNORED_MODIFIED_LINES_BORDER_COLOR);
        this.addHighlighter(new Range(15, 16, 0, 0), true, EditorColors.IGNORED_ADDED_LINES_BORDER_COLOR);
        List<Color> annotationColors = AnnotationsSettings.getInstance().getOrderedColors(colorsScheme);
        List<Integer> anchorIndexes = AnnotationsSettings.getInstance().getAnchorIndexes(colorsScheme);
        this.myEditor.getGutterComponentEx().registerTextAnnotation((TextAnnotationGutterProvider)new MyTextAnnotationGutterProvider(annotationColors, anchorIndexes));
    }

    @NotNull
    private static Range createModifiedRange(int currentLine, byte ... inner) {
        ArrayList<Range.InnerRange> innerRanges = new ArrayList<Range.InnerRange>();
        int currentInnerLine = 0;
        block4: for (byte type : inner) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: {
                    innerRanges.add(new Range.InnerRange(currentInnerLine, currentInnerLine + 1, type));
                    ++currentInnerLine;
                    continue block4;
                }
                case 3: {
                    innerRanges.add(new Range.InnerRange(currentInnerLine, currentInnerLine, type));
                }
            }
        }
        return new Range(currentLine, currentLine + currentInnerLine, 0, 1, innerRanges);
    }

    private void addHighlighter(final @NotNull Range range, final boolean isIgnored, final @NotNull ColorKey colorKey) {
        RangeHighlighter highlighter = LineStatusMarkerRenderer.createTooltipRangeHighlighter((Range)range, (MarkupModel)this.myEditor.getMarkupModel());
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new ActiveGutterRenderer(){

            public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
                LineStatusMarkerRenderer.paintRange((Graphics)g, (Editor)VcsPreviewPanel.this.myEditor, (Range)range, (int)0, (boolean)isIgnored);
            }

            public boolean canDoAction(@NotNull MouseEvent e) {
                return LineStatusMarkerRenderer.isInsideMarkerArea((MouseEvent)e);
            }

            public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
                ((ColorAndFontSettingsListener)VcsPreviewPanel.this.myDispatcher.getMulticaster()).selectionInPreviewChanged(colorKey.getExternalName());
            }

            @NotNull
            public String getAccessibleName() {
                return DiffBundle.message((String)"vcs.marker.changed.line", (Object[])new Object[0]);
            }
        });
    }

    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        this.myEditor.setColorsScheme(highlighterSettings);
    }

    private static class MyTextAnnotationGutterProvider
    implements TextAnnotationGutterProvider {
        @NotNull
        private final List<? extends Color> myBackgroundColors;
        @NotNull
        private final List<Integer> myAnchorIndexes;

        MyTextAnnotationGutterProvider(@NotNull List<? extends Color> backgroundColors, @NotNull List<Integer> anchorIndexes) {
            this.myBackgroundColors = backgroundColors;
            this.myAnchorIndexes = anchorIndexes;
        }

        @Nullable
        public String getLineText(int line, Editor editor) {
            if (line < this.myBackgroundColors.size()) {
                int anchorIndex = this.myAnchorIndexes.indexOf(line);
                String text2 = "Annotation background";
                if (anchorIndex != -1) {
                    text2 = text2 + " #" + (anchorIndex + 1);
                }
                return text2;
            }
            return null;
        }

        @Nullable
        public String getToolTip(int line, Editor editor) {
            return null;
        }

        public EditorFontType getStyle(int line, Editor editor) {
            return null;
        }

        @Nullable
        public ColorKey getColor(int line, Editor editor) {
            return EditorColors.ANNOTATIONS_COLOR;
        }

        @Nullable
        public Color getBgColor(int line, Editor editor) {
            if (line < this.myBackgroundColors.size()) {
                return this.myBackgroundColors.get(line);
            }
            return null;
        }

        public List<AnAction> getPopupActions(int line, Editor editor) {
            return Collections.emptyList();
        }

        public void gutterClosed() {
        }
    }
}

