/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryForRevisionAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        boolean visible = TabbedShowHistoryForRevisionAction.isVisible(e);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && TabbedShowHistoryForRevisionAction.isEnabled(e));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        VcsRevisionNumber revisionNumber;
        String revisionNumberString;
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        AbstractVcs vcs = Objects.requireNonNull(TabbedShowHistoryForRevisionAction.getVcs(project, (VcsKey)event.getData(VcsDataKeys.VCS)));
        Pair<FilePath, VcsRevisionNumber> fileAndRevision = Objects.requireNonNull(TabbedShowHistoryForRevisionAction.getFileAndRevision(event));
        FilePath file = (FilePath)fileAndRevision.getFirst();
        if (TabbedShowHistoryForRevisionAction.canShowNewFileHistory(project, file, revisionNumberString = (revisionNumber = (VcsRevisionNumber)fileAndRevision.getSecond()).asString())) {
            TabbedShowHistoryForRevisionAction.showNewFileHistory(project, file, revisionNumberString);
        } else {
            VcsHistoryProviderEx vcsHistoryProvider = Objects.requireNonNull((VcsHistoryProviderEx)vcs.getVcsHistoryProvider());
            AbstractVcsHelperImpl helper = Objects.requireNonNull(TabbedShowHistoryForRevisionAction.getVcsHelper(project));
            helper.showFileHistory(vcsHistoryProvider, file, vcs, revisionNumber);
        }
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull FilePath path2, @NotNull String revisionNumber) {
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(project, Collections.singletonList(path2), revisionNumber);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull FilePath path2, @NotNull String revisionNumber) {
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        return historyProvider != null && historyProvider.canShowFileHistory(project, Collections.singletonList(path2), revisionNumber);
    }

    private static boolean isVisible(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        if (project == null || project.isDisposed()) {
            return false;
        }
        if (TabbedShowHistoryForRevisionAction.getVcsHelper(project) == null) {
            return false;
        }
        AbstractVcs vcs = TabbedShowHistoryForRevisionAction.getVcs(project, (VcsKey)event.getData(VcsDataKeys.VCS));
        if (vcs == null) {
            return false;
        }
        VcsHistoryProvider vcsHistoryProvider = vcs.getVcsHistoryProvider();
        return vcsHistoryProvider instanceof VcsHistoryProviderEx;
    }

    private static boolean isEnabled(@NotNull AnActionEvent event) {
        return TabbedShowHistoryForRevisionAction.getFileAndRevision(event) != null;
    }

    @Nullable
    private static Pair<FilePath, VcsRevisionNumber> getFileAndRevision(@NotNull AnActionEvent event) {
        Change[] changes = (Change[])event.getData(VcsDataKeys.SELECTED_CHANGES);
        if (changes == null || changes.length != 1) {
            return null;
        }
        Change change = changes[0];
        Pair<FilePath, VcsRevisionNumber> fileAndRevision = TabbedShowHistoryForRevisionAction.getFileAndRevision(change);
        if (fileAndRevision == null || change.getType() != Change.Type.DELETED) {
            return fileAndRevision;
        }
        Project project = event.getProject();
        if (project == null || !TabbedShowHistoryForRevisionAction.canShowNewFileHistory(project, (FilePath)fileAndRevision.getFirst(), ((VcsRevisionNumber)fileAndRevision.getSecond()).asString())) {
            return fileAndRevision;
        }
        VcsRevisionNumber revisionNumber = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER);
        if (revisionNumber == null) {
            return fileAndRevision;
        }
        return Pair.create((Object)fileAndRevision.getFirst(), (Object)revisionNumber);
    }

    @Nullable
    private static Pair<FilePath, VcsRevisionNumber> getFileAndRevision(@NotNull Change change) {
        ContentRevision revision;
        ContentRevision contentRevision = revision = change.getType() == Change.Type.DELETED ? change.getBeforeRevision() : change.getAfterRevision();
        if (revision == null) {
            return null;
        }
        return Pair.create((Object)revision.getFile(), (Object)revision.getRevisionNumber());
    }

    @Nullable
    private static AbstractVcs getVcs(@NotNull Project project, @Nullable VcsKey vcsKey) {
        return vcsKey == null ? null : ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(vcsKey.getName());
    }

    @Nullable
    private static AbstractVcsHelperImpl getVcsHelper(@NotNull Project project) {
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
        return (AbstractVcsHelperImpl)((Object)ObjectUtils.tryCast((Object)helper, AbstractVcsHelperImpl.class));
    }
}

