/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends AbstractVcsAction
implements UpdateInBackground {
    private static final long MANY_CHANGES_THRESHOLD = 1000L;

    @Override
    protected void update(@NotNull VcsContext context, @NotNull Presentation presentation) {
        Project project = context.getProject();
        presentation.setEnabled(this.isEnabled(context));
        presentation.setVisible(project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss());
    }

    protected boolean isEnabled(@NotNull VcsContext context) {
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        List<FilePath> selectedFiles = context.getSelectedFilePathsStream().limit(1000L).collect(Collectors.toList());
        if (selectedFiles.isEmpty()) {
            return false;
        }
        if (TabbedShowHistoryAction.canShowNewFileHistory(project, selectedFiles)) {
            return ContainerUtil.all(selectedFiles, path2 -> AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)path2));
        }
        if (selectedFiles.size() == 1) {
            FilePath selectedPath = (FilePath)ContainerUtil.getFirstItem(selectedFiles);
            if (selectedPath == null) {
                return false;
            }
            VirtualFile fileOrParent = TabbedShowHistoryAction.getExistingFileOrParent(selectedPath);
            if (fileOrParent == null) {
                return false;
            }
            if (TabbedShowHistoryAction.canShowOldFileHistory(project, selectedPath, fileOrParent)) {
                return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)selectedPath);
            }
        }
        return false;
    }

    private static boolean canShowOldFileHistory(@NotNull Project project, @NotNull FilePath path2, @NotNull VirtualFile fileOrParent) {
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project);
        if (vcs == null) {
            return false;
        }
        VcsHistoryProvider provider = vcs.getVcsHistoryProvider();
        return provider != null && (provider.supportsHistoryForDirectories() || !path2.isDirectory()) && provider.canShowHistoryFor(fileOrParent);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull Collection<FilePath> paths) {
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        return historyProvider != null && historyProvider.canShowFileHistory(project, paths, null);
    }

    @Nullable
    private static VirtualFile getExistingFileOrParent(@NotNull FilePath selectedPath) {
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)selectedPath.getVirtualFile(), (Object)selectedPath.getVirtualFileParent());
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        List<FilePath> selectedFiles;
        Project project = Objects.requireNonNull(context.getProject());
        if (TabbedShowHistoryAction.canShowNewFileHistory(project, selectedFiles = context.getSelectedFilePathsStream().collect(Collectors.toList()))) {
            TabbedShowHistoryAction.showNewFileHistory(project, selectedFiles);
        } else if (selectedFiles.size() == 1) {
            FilePath path2 = (FilePath)Objects.requireNonNull(ContainerUtil.getFirstItem(selectedFiles));
            AbstractVcs vcs = Objects.requireNonNull(ChangesUtil.getVcsForFile((VirtualFile)Objects.requireNonNull(TabbedShowHistoryAction.getExistingFileOrParent(path2)), (Project)project));
            TabbedShowHistoryAction.showOldFileHistory(project, vcs, path2);
        }
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull Collection<FilePath> paths) {
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(project, paths, null);
    }

    private static void showOldFileHistory(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull FilePath path2) {
        VcsHistoryProvider provider = Objects.requireNonNull(vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance((Project)project).showFileHistory(provider, vcs.getAnnotationProvider(), path2, vcs);
    }
}

