/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;

public class ShowHideAspectAction
extends ToggleAction
implements DumbAware {
    private final AnnotationFieldGutter myGutter;
    private boolean isAvailable = true;

    public ShowHideAspectAction(AnnotationFieldGutter gutter) {
        super(gutter.getID());
        this.myGutter = gutter;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return this.isSelected();
    }

    boolean isSelected() {
        return this.myGutter.isAvailable();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        VcsUtil.setAspectAvailability((String)this.myGutter.getID(), (boolean)state);
        AnnotateActionGroup.revalidateMarkupInAllEditors();
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.isAvailable);
    }

    public void setAvailable(boolean available) {
        this.isAvailable = available;
    }
}

