/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsCheckoutProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectSetProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsProjectSetProcessor
extends ProjectSetProcessor {
    private static final Logger LOG = Logger.getInstance(VcsProjectSetProcessor.class);

    public String getId() {
        return "vcs";
    }

    public void processEntries(final @NotNull List<? extends Pair<String, String>> entries, final @NotNull ProjectSetProcessor.Context context, final @NotNull Runnable runNext) {
        if (!VcsProjectSetProcessor.getDirectory(context)) {
            return;
        }
        if (!VcsProjectSetProcessor.getDirectoryName(context)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, VcsBundle.message((String)"progress.title.hey", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                for (Pair pair : entries) {
                    String vcs = (String)pair.getFirst();
                    VcsCheckoutProcessor processor = VcsCheckoutProcessor.getProcessor((String)vcs);
                    if (processor == null) {
                        LOG.error("Checkout processor not found for " + vcs);
                        return;
                    }
                    JsonElement element = new JsonParser().parse((String)pair.getSecond());
                    HashMap parameters = new HashMap();
                    for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                        JsonElement value = (JsonElement)entry.getValue();
                        parameters.put(entry.getKey(), value instanceof JsonPrimitive ? value.getAsString() : value.toString());
                    }
                    String directoryName = context.directoryName;
                    if (parameters.get("targetDir") != null) {
                        directoryName = directoryName + "/" + (String)parameters.get("targetDir");
                    }
                    if (processor.checkout(parameters, context.directory, directoryName)) continue;
                    return;
                }
                runNext.run();
            }
        });
    }

    private static boolean getDirectoryName(@NotNull ProjectSetProcessor.Context context) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            context.directoryName = "test";
            return true;
        }
        context.directoryName = Messages.showInputDialog((Project)null, (String)VcsBundle.message((String)"dialog.message.enter.directory.name", (Object[])new Object[]{context.directory.getName()}), (String)VcsBundle.message((String)"dialog.title.project.directory.name", (Object[])new Object[0]), null, (String)context.directoryName, null);
        return context.directoryName != null;
    }

    private static boolean getDirectory(@NotNull ProjectSetProcessor.Context context) {
        if (context.directory != null) {
            return true;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor.setTitle(VcsBundle.message((String)"dialog.title.select.destination.folder", (Object[])new Object[0]));
        descriptor.setDescription("");
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, null);
        context.directory = files.length == 0 ? null : files[0];
        return context.directory != null;
    }
}

