/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PlainTextSymbolCompletionContributor;
import com.intellij.codeInsight.completion.PlainTextSymbolCompletionContributorEP;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class CommitCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiFile file = parameters.getOriginalFile();
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return;
        }
        CommitMessage commitMessage2 = (CommitMessage)document.getUserData(CommitMessage.DATA_KEY);
        if (commitMessage2 == null) {
            return;
        }
        result2.stopHere();
        int count = parameters.getInvocationCount();
        List<ChangeList> lists = commitMessage2.getChangeLists();
        if (lists.isEmpty()) {
            return;
        }
        String prefix = TextFieldWithAutoCompletionListProvider.getCompletionPrefix((CompletionParameters)parameters);
        if (count == 0 && prefix.length() < 5) {
            result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().withLength(5));
            return;
        }
        CompletionResultSet resultSet = result2.caseInsensitive().withPrefixMatcher((PrefixMatcher)(count == 0 ? new PlainPrefixMatcher(prefix, true) : new CamelHumpMatcher(prefix)));
        CompletionResultSet prefixed = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix, count == 0));
        for (ChangeList list : lists) {
            ProgressManager.checkCanceled();
            for (Change change : list.getChanges()) {
                ProgressManager.checkCanceled();
                FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
                FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
                if (afterPath != null) {
                    CommitCompletionContributor.addFilePathName(resultSet, afterPath, false);
                    CommitCompletionContributor.addLanguageSpecificElements(project, count, prefixed, afterPath);
                }
                if (beforePath == null || afterPath != null && beforePath.getName().equals(afterPath.getName())) continue;
                CommitCompletionContributor.addFilePathName(resultSet, beforePath, true);
            }
            if (count <= 0) continue;
            result2.caseInsensitive().withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix)).addAllElements((Iterable)StreamEx.of((Collection)VcsConfiguration.getInstance((Project)project).getRecentMessages()).reverseSorted().map(lookupString -> PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)lookupString), (double)-2.147483648E9)));
        }
    }

    private static void addFilePathName(CompletionResultSet resultSet, FilePath filePath, boolean strikeout) {
        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)filePath.getName()).withIcon(filePath.getFileType().getIcon()).withStrikeoutness(strikeout));
    }

    private static void addLanguageSpecificElements(Project project, int count, CompletionResultSet prefixed, FilePath filePath) {
        VirtualFile vFile = filePath.getVirtualFile();
        if (vFile == null) {
            return;
        }
        PsiFile psiFile = PsiManagerEx.getInstanceEx((Project)project).findFile(vFile);
        if (psiFile == null) {
            return;
        }
        PlainTextSymbolCompletionContributor contributor = PlainTextSymbolCompletionContributorEP.forLanguage((Language)psiFile.getLanguage());
        if (contributor == null) {
            return;
        }
        prefixed.addAllElements((Iterable)contributor.getLookupElements(psiFile, count, prefixed.getPrefixMatcher().getPrefix()));
    }
}

