/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.util;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CommitCompareInfo {
    private static final Logger LOG = Logger.getInstance(CommitCompareInfo.class);
    private final Map<Repository, Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>>> myInfo = new HashMap<Repository, Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>>>();
    private final Map<Repository, Collection<Change>> myTotalDiff = new HashMap<Repository, Collection<Change>>();
    private final InfoType myInfoType;

    public CommitCompareInfo() {
        this(InfoType.BOTH);
    }

    public CommitCompareInfo(@NotNull InfoType infoType) {
        this.myInfoType = infoType;
    }

    public void put(@NotNull Repository repository, @NotNull List<? extends VcsFullCommitDetails> headToBranch, @NotNull List<? extends VcsFullCommitDetails> branchToHead) {
        this.myInfo.put(repository, (Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>>)Couple.of(headToBranch, branchToHead));
    }

    public void putTotalDiff(@NotNull Repository repository, @NotNull Collection<Change> totalDiff) {
        this.myTotalDiff.put(repository, totalDiff);
    }

    @NotNull
    public List<VcsFullCommitDetails> getHeadToBranchCommits(@NotNull Repository repo) {
        return (List)this.getCompareInfo(repo).getFirst();
    }

    @NotNull
    public List<VcsFullCommitDetails> getBranchToHeadCommits(@NotNull Repository repo) {
        return (List)this.getCompareInfo(repo).getSecond();
    }

    @NotNull
    private Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>> getCompareInfo(@NotNull Repository repo) {
        Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>> pair = this.myInfo.get(repo);
        if (pair == null) {
            LOG.error("Compare info not found for repository " + repo);
            return Pair.create(Collections.emptyList(), Collections.emptyList());
        }
        return pair;
    }

    @NotNull
    public Collection<Repository> getRepositories() {
        return this.myTotalDiff.keySet();
    }

    public boolean isEmpty() {
        return this.myInfo.isEmpty();
    }

    public InfoType getInfoType() {
        return this.myInfoType;
    }

    @NotNull
    public List<Change> getTotalDiff() {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Collection<Change> changeCollection : this.myTotalDiff.values()) {
            changes.addAll(changeCollection);
        }
        return changes;
    }

    protected void updateTotalDiff(@NotNull Map<Repository, Collection<Change>> newDiff) {
        this.myTotalDiff.clear();
        this.myTotalDiff.putAll(newDiff);
    }

    public static enum InfoType {
        BOTH,
        HEAD_TO_BRANCH,
        BRANCH_TO_HEAD;

    }
}

