/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogSingleCommitAction<Repo extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)log.getSelectedCommits());
        assert (commit != null);
        Repo repository = this.getRepositoryForRoot(project, commit.getRoot());
        assert (repository != null);
        this.actionPerformed(repository, commit.getHash());
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = log.getSelectedCommits();
        if (commits.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)commits);
        assert (commit != null);
        Repo repository = this.getRepositoryForRoot(project, commit.getRoot());
        if (repository == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(this.isVisible(project, repository, commit.getHash()));
        e.getPresentation().setEnabled(commits.size() == 1 && this.isEnabled(repository, commit.getHash()));
    }

    protected abstract void actionPerformed(@NotNull Repo var1, @NotNull Hash var2);

    protected boolean isEnabled(@NotNull Repo repository, @NotNull Hash commit) {
        return true;
    }

    protected boolean isVisible(@NotNull Project project, @NotNull Repo repository, @NotNull Hash hash) {
        return !this.getRepositoryManager(project).isExternal(repository);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);
}

