/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.CustomIconProvider;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.FlatSpeedSearchPopup;
import com.intellij.openapi.vcs.ui.PopupListElementRendererWithIcon;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BranchActionGroupPopup
extends FlatSpeedSearchPopup {
    private static final DataKey<ListPopupModel> POPUP_MODEL = DataKey.create((String)"VcsPopupModel");
    static final String BRANCH_POPUP = "BranchWidget";
    private Project myProject;
    private MyPopupListElementRenderer myListElementRenderer;
    private boolean myShown;
    private boolean myUserSizeChanged;
    private boolean myInternalSizeChanged;
    private int myMeanRowHeight;
    @Nullable
    private final String myKey;
    @NotNull
    private Dimension myPrevSize = JBUI.emptySize();
    private final List<AnAction> mySettingsActions = new ArrayList<AnAction>();
    private final List<AnAction> myToolbarActions = new ArrayList<AnAction>();

    public BranchActionGroupPopup(@NotNull String title2, @NotNull Project project, @NotNull Condition<? super AnAction> preselectActionCondition, @NotNull ActionGroup actions, @Nullable String dimensionKey) {
        super(title2, BranchActionGroupPopup.createBranchSpeedSearchActionGroup(actions), SimpleDataContext.getProjectContext((Project)project), preselectActionCondition, true);
        this.getTitle().setBackground(JBColor.PanelBackground);
        this.myProject = project;
        DataManager.registerDataProvider((JComponent)this.getList(), dataId -> POPUP_MODEL.is(dataId) ? this.getListModel() : null);
        this.myKey = dimensionKey;
        if (this.myKey != null) {
            Dimension storedSize = WindowStateService.getInstance((Project)this.myProject).getSizeFor((Object)this.myProject, this.myKey);
            if (storedSize != null) {
                this.setSize(storedSize);
                this.myUserSizeChanged = true;
            }
            this.createTitlePanelToolbar(this.myKey);
        }
        this.setSpeedSearchAlwaysShown();
        this.myMeanRowHeight = this.getList().getCellBounds((int)0, (int)0).height + UIUtil.getListCellVPadding() * 2;
    }

    private void createTitlePanelToolbar(final @NotNull String dimensionKey) {
        LightActionGroup actionGroup = new LightActionGroup(){

            @Override
            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                return BranchActionGroupPopup.this.myToolbarActions.toArray(AnAction.EMPTY_ARRAY);
            }
        };
        AnAction restoreSizeButton = new AnAction(DvcsBundle.messagePointer("action.BranchActionGroupPopup.Anonymous.text.restore.size", new Object[0]), AllIcons.General.CollapseComponentHover){

            public void actionPerformed(@NotNull AnActionEvent e) {
                WindowStateService.getInstance((Project)BranchActionGroupPopup.this.myProject).putSizeFor((Object)BranchActionGroupPopup.this.myProject, dimensionKey, null);
                BranchActionGroupPopup.this.myInternalSizeChanged = true;
                BranchActionGroupPopup.this.pack(true, true);
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(BranchActionGroupPopup.this.myUserSizeChanged);
            }
        };
        ActionGroup settingsGroup = new ActionGroup(DvcsBundle.message("action.BranchActionGroupPopup.settings.text", new Object[0]), true){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                return BranchActionGroupPopup.this.mySettingsActions.toArray(AnAction.EMPTY_ARRAY);
            }

            public boolean hideIfNoVisibleChildren() {
                return true;
            }
        };
        settingsGroup.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        this.myToolbarActions.add(restoreSizeButton);
        this.myToolbarActions.add((AnAction)settingsGroup);
        final ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(BRANCH_POPUP, (ActionGroup)actionGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setOpaque(false);
        this.getTitle().setButtonComponent((ActiveComponent)new ActiveComponent.Adapter(){

            @NotNull
            public JComponent getComponent() {
                return toolbar.getComponent();
            }
        }, (Border)JBUI.Borders.emptyRight((int)2));
    }

    private BranchActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep aStep, @Nullable Object parentValue) {
        super(aParent, aStep, DataContext.EMPTY_CONTEXT, parentValue);
        this.myKey = null;
        DataManager.registerDataProvider((JComponent)this.getList(), dataId -> POPUP_MODEL.is(dataId) ? this.getListModel() : null);
    }

    private void trackDimensions(final @Nullable String dimensionKey) {
        final Window popupWindow = this.getPopupWindow();
        if (popupWindow == null) {
            return;
        }
        final ComponentAdapter windowListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BranchActionGroupPopup.this.myShown) {
                    BranchActionGroupPopup.this.processOnSizeChanged();
                }
            }
        };
        popupWindow.addComponentListener(windowListener);
        this.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                popupWindow.removeComponentListener(windowListener);
                if (dimensionKey != null && BranchActionGroupPopup.this.myUserSizeChanged) {
                    WindowStateService.getInstance((Project)BranchActionGroupPopup.this.myProject).putSizeFor((Object)BranchActionGroupPopup.this.myProject, dimensionKey, BranchActionGroupPopup.this.myPrevSize);
                }
            }
        });
    }

    private void processOnSizeChanged() {
        boolean sizeWasIncreased;
        Dimension newSize = Objects.requireNonNull(this.getSize());
        int preferredHeight = this.getComponent().getPreferredSize().height;
        int realHeight = this.getComponent().getHeight();
        boolean shouldExpand = preferredHeight + this.myMeanRowHeight < realHeight;
        boolean bl = sizeWasIncreased = this.myPrevSize.height < newSize.height;
        if (!this.myInternalSizeChanged && sizeWasIncreased && shouldExpand) {
            List<MoreAction> mores = this.getMoreActions();
            for (MoreAction more : mores) {
                if (!this.getList().getScrollableTracksViewportHeight()) break;
                if (more.isExpanded()) continue;
                more.setExpanded(true);
                this.getListModel().refilter();
            }
        }
        this.myPrevSize = newSize;
        this.myUserSizeChanged = !this.myInternalSizeChanged;
        this.myInternalSizeChanged = false;
    }

    @NotNull
    private List<MoreAction> getMoreActions() {
        ArrayList<MoreAction> result2 = new ArrayList<MoreAction>();
        ListPopupModel model = this.getListModel();
        for (int i = 0; i < model.getSize(); ++i) {
            MoreAction moreAction = BranchActionGroupPopup.getSpecificAction(model.getElementAt(i), MoreAction.class);
            if (moreAction == null) continue;
            result2.add(moreAction);
        }
        return result2;
    }

    public void addToolbarAction(@NotNull AnAction action, boolean underSettingsPopup) {
        if (underSettingsPopup) {
            this.mySettingsActions.add(action);
        } else {
            this.myToolbarActions.add(0, action);
        }
    }

    public void update() {
        this.getContent().revalidate();
        this.getContent().repaint();
    }

    @NotNull
    private static ActionGroup createBranchSpeedSearchActionGroup(@NotNull ActionGroup actions) {
        LightActionGroup group = new LightActionGroup();
        group.add((AnAction)actions);
        group.addAll(BranchActionGroupPopup.createSpeedSearchActions(actions, true));
        return group;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void afterShow() {
        super.afterShow();
        this.myShown = true;
        Dimension size = this.getSize();
        if (size != null) {
            this.myPrevSize = size;
        }
        this.trackDimensions(this.myKey);
    }

    private static List<AnAction> createSpeedSearchActions(@NotNull ActionGroup parentActionGroup, boolean isFirstLevel) {
        if (parentActionGroup instanceof HideableActionGroup) {
            parentActionGroup = ((HideableActionGroup)parentActionGroup).getDelegate();
        }
        if (parentActionGroup instanceof BranchActionGroup) {
            return Collections.emptyList();
        }
        ArrayList<AnAction> speedSearchActions = new ArrayList<AnAction>();
        if (!isFirstLevel) {
            speedSearchActions.add((AnAction)new Separator(parentActionGroup.getTemplatePresentation().getText()));
        }
        for (AnAction child : parentActionGroup.getChildren(null)) {
            if (!(child instanceof ActionGroup)) continue;
            ActionGroup childGroup = (ActionGroup)child;
            if (childGroup instanceof HideableActionGroup) {
                childGroup = ((HideableActionGroup)childGroup).getDelegate();
            }
            if (isFirstLevel) {
                speedSearchActions.addAll(BranchActionGroupPopup.createSpeedSearchActions(childGroup, false));
                continue;
            }
            if (!(childGroup instanceof BranchActionGroup)) continue;
            speedSearchActions.add((AnAction)BranchActionGroupPopup.createSpeedSearchActionGroupWrapper(childGroup));
        }
        return speedSearchActions;
    }

    public void handleSelect(boolean handleFinalChoices) {
        super.handleSelect(handleFinalChoices, null);
        if (BranchActionGroupPopup.getSpecificAction(this.getList().getSelectedValue(), MoreAction.class) != null) {
            this.getListModel().refilter();
        }
    }

    public void handleSelect(boolean handleFinalChoices, InputEvent e) {
        BranchActionGroup branchActionGroup = this.getSelectedBranchGroup();
        if (branchActionGroup != null && e instanceof MouseEvent && this.myListElementRenderer.isIconAt(((MouseEvent)e).getPoint())) {
            branchActionGroup.toggle();
            this.getList().repaint();
        } else {
            super.handleSelect(handleFinalChoices, e);
        }
    }

    protected void handleToggleAction() {
        BranchActionGroup branchActionGroup = this.getSelectedBranchGroup();
        if (branchActionGroup != null) {
            branchActionGroup.toggle();
            this.getList().repaint();
        } else {
            super.handleToggleAction();
        }
    }

    @Nullable
    private BranchActionGroup getSelectedBranchGroup() {
        return BranchActionGroupPopup.getSpecificAction(this.getList().getSelectedValue(), BranchActionGroup.class);
    }

    protected void onSpeedSearchPatternChanged() {
        String newFilter = this.mySpeedSearch.getFilter();
        if (newFilter.endsWith(" ")) {
            this.mySpeedSearch.updatePattern(newFilter.trim());
            return;
        }
        this.getList().setSelectedIndex(0);
        super.onSpeedSearchPatternChanged();
        ScrollingUtil.ensureSelectionExists((JList)this.getList());
    }

    protected boolean shouldUseStatistics() {
        return false;
    }

    @Override
    protected boolean shouldBeShowing(@NotNull AnAction action) {
        if (!super.shouldBeShowing(action)) {
            return false;
        }
        if (this.getSpeedSearch().isHoldingFilter()) {
            return !(action instanceof MoreAction);
        }
        if (action instanceof MoreHideableActionGroup) {
            return ((MoreHideableActionGroup)action).shouldBeShown();
        }
        return true;
    }

    protected WizardPopup createPopup(WizardPopup parent, PopupStep step2, Object parentValue) {
        return this.createListPopupStep(parent, step2, parentValue);
    }

    private WizardPopup createListPopupStep(WizardPopup parent, PopupStep step2, Object parentValue) {
        if (step2 instanceof ListPopupStep) {
            return new BranchActionGroupPopup(parent, (ListPopupStep)step2, parentValue);
        }
        return super.createPopup(parent, step2, parentValue);
    }

    protected MyPopupListElementRenderer getListElementRenderer() {
        if (this.myListElementRenderer == null) {
            this.myListElementRenderer = new MyPopupListElementRenderer((ListPopupImpl)this);
        }
        return this.myListElementRenderer;
    }

    public static void wrapWithMoreActionIfNeeded(@NotNull Project project, @NotNull LightActionGroup parentGroup, @NotNull List<? extends ActionGroup> actionList, int maxIndex, @Nullable String settingName) {
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded(project, parentGroup, actionList, maxIndex, settingName, false);
    }

    public static void wrapWithMoreActionIfNeeded(@NotNull Project project, @NotNull LightActionGroup parentGroup, @NotNull List<? extends ActionGroup> actionList, int maxIndex, @Nullable String settingName, boolean defaultExpandValue) {
        if (actionList.size() > maxIndex) {
            boolean hasFavorites = actionList.stream().anyMatch(action -> action instanceof BranchActionGroup && ((BranchActionGroup)action).isFavorite());
            MoreAction moreAction = new MoreAction(project, actionList.size() - maxIndex, settingName, defaultExpandValue, hasFavorites);
            for (int i = 0; i < actionList.size(); ++i) {
                parentGroup.add((AnAction)(i < maxIndex ? (AnAction)actionList.get(i) : new HideableActionGroup(actionList.get(i), moreAction)));
            }
            parentGroup.add((AnAction)moreAction);
        } else {
            parentGroup.addAll(actionList);
        }
    }

    private static class HideableActionGroup
    extends EmptyAction.MyDelegatingActionGroup
    implements MoreHideableActionGroup,
    DumbAware {
        @NotNull
        private final MoreAction myMoreAction;

        private HideableActionGroup(@NotNull ActionGroup actionGroup, @NotNull MoreAction moreAction) {
            super(actionGroup);
            this.myMoreAction = moreAction;
        }

        @Override
        public boolean shouldBeShown() {
            return this.myMoreAction.isExpanded();
        }
    }

    static interface MoreHideableActionGroup {
        public boolean shouldBeShown();
    }

    private static class MoreAction
    extends DumbAwareAction
    implements KeepingPopupOpenAction {
        @NotNull
        private final Project myProject;
        @Nullable
        private final String mySettingName;
        private final boolean myDefaultExpandValue;
        private boolean myIsExpanded;
        @NotNull
        private final String myToCollapseText;
        @NotNull
        private final String myToExpandText;

        MoreAction(@NotNull Project project, int numberOfHiddenNodes, @Nullable String settingName, boolean defaultExpandValue, boolean hasFavorites) {
            this.myProject = project;
            this.mySettingName = settingName;
            this.myDefaultExpandValue = defaultExpandValue;
            assert (numberOfHiddenNodes > 0);
            this.myToExpandText = "Show " + numberOfHiddenNodes + " More...";
            this.myToCollapseText = "Show " + (hasFavorites ? "Only Favorites" : "Less");
            this.setExpanded(settingName != null ? PropertiesComponent.getInstance((Project)project).getBoolean(settingName, defaultExpandValue) : defaultExpandValue);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataProvider dataProvider;
            this.setExpanded(!this.myIsExpanded);
            InputEvent event = e.getInputEvent();
            if (event != null && event.getSource() instanceof JComponent && (dataProvider = DataManager.getDataProvider((JComponent)((JComponent)event.getSource()))) != null) {
                ((ListPopupModel)Objects.requireNonNull(POPUP_MODEL.getData(dataProvider))).refilter();
            }
        }

        public boolean isExpanded() {
            return this.myIsExpanded;
        }

        public void setExpanded(boolean isExpanded) {
            this.myIsExpanded = isExpanded;
            this.saveState();
            this.updateActionText();
        }

        private void updateActionText() {
            this.getTemplatePresentation().setText(this.myIsExpanded ? this.myToCollapseText : this.myToExpandText);
        }

        public void saveState() {
            if (this.mySettingName != null) {
                PropertiesComponent.getInstance((Project)this.myProject).setValue(this.mySettingName, this.myIsExpanded, this.myDefaultExpandValue);
            }
        }
    }

    private static class MyTextSeparator
    extends SeparatorWithText {
        MyTextSeparator() {
            this.setTextForeground(UIUtil.getListForeground());
            this.setCaptionCentered(false);
            UIUtil.addInsets((JComponent)((Object)this), (int)4, (int)UIUtil.getListCellHPadding(), (int)0, (int)0);
        }

        protected void paintLine(Graphics g, int x, int y, int width) {
            if (StringUtil.isEmptyOrSpaces((String)this.getCaption())) {
                super.paintLine(g, x, y, width);
            }
        }
    }

    private static class MyPopupListElementRenderer
    extends PopupListElementRendererWithIcon {
        private ErrorLabel myInfoLabel;

        MyPopupListElementRenderer(ListPopupImpl aPopup) {
            super(aPopup);
        }

        protected SeparatorWithText createSeparator() {
            return new MyTextSeparator();
        }

        protected void customizeComponent(JList list, Object value, boolean isSelected) {
            PopupElementWithAdditionalInfo additionalInfoAction;
            MoreAction more = (MoreAction)((Object)BranchActionGroupPopup.getSpecificAction(value, MoreAction.class));
            if (more != null) {
                this.myTextLabel.setForeground((Color)JBColor.gray);
            }
            super.customizeComponent(list, value, isSelected);
            CustomIconProvider actionWithIconProvider = (CustomIconProvider)BranchActionGroupPopup.getSpecificAction(value, CustomIconProvider.class);
            if (actionWithIconProvider != null) {
                this.myTextLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                this.myTextLabel.setIcon(actionWithIconProvider.getRightIcon());
            }
            this.updateInfoComponent(this.myInfoLabel, (additionalInfoAction = (PopupElementWithAdditionalInfo)BranchActionGroupPopup.getSpecificAction(value, PopupElementWithAdditionalInfo.class)) != null ? additionalInfoAction.getInfoText() : null, isSelected);
        }

        private void updateInfoComponent(@NotNull ErrorLabel infoLabel, @Nullable String infoText, boolean isSelected) {
            if (infoText != null) {
                infoLabel.setVisible(true);
                infoLabel.setText(infoText);
                if (isSelected) {
                    this.setSelected((JComponent)infoLabel);
                } else {
                    infoLabel.setBackground(this.getBackground());
                    infoLabel.setForeground((Color)JBColor.GRAY);
                }
            } else {
                infoLabel.setVisible(false);
            }
        }

        @Override
        protected JComponent createItemComponent() {
            this.myTextLabel = new ErrorLabel();
            this.myTextLabel.setOpaque(true);
            this.myTextLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myInfoLabel = new ErrorLabel();
            this.myInfoLabel.setOpaque(true);
            this.myInfoLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)1, (int)1));
            this.myInfoLabel.setFont(FontUtil.minusOne((Font)this.myInfoLabel.getFont()));
            OpaquePanel compoundPanel = new OpaquePanel((LayoutManager)new BorderLayout(), (Color)JBColor.WHITE);
            this.myIconLabel = new PopupListElementRendererWithIcon.IconComponent();
            this.myInfoLabel.setHorizontalAlignment(4);
            OpaquePanel compoundTextPanel = new OpaquePanel((LayoutManager)new BorderLayout(), compoundPanel.getBackground());
            OpaquePanel textPanel = new OpaquePanel((LayoutManager)new BorderLayout(), compoundPanel.getBackground());
            compoundPanel.add((Component)this.myIconLabel, "West");
            textPanel.add((Component)this.myTextLabel, "West");
            textPanel.add((Component)this.myInfoLabel, "Center");
            compoundTextPanel.add((Component)textPanel, "Center");
            compoundPanel.add((Component)compoundTextPanel, "Center");
            return this.layoutComponent((JComponent)compoundPanel);
        }
    }
}

