/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLinkedTextComponent
extends JLabel {
    private static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");
    @NotNull
    private final String myTextBefore;
    @NotNull
    private final String myTextAfter;
    @NotNull
    private String myHandledLink;
    @Nullable
    private final VcsLinkListener myLinkListener;
    private boolean mySelected;
    private boolean myUnderlined;
    private boolean myTransparent;

    public VcsLinkedTextComponent(@NotNull String text2, @Nullable VcsLinkListener listener2) {
        Matcher aMatcher = HREF_PATTERN.matcher(text2);
        if (aMatcher.find()) {
            this.myTextBefore = text2.substring(0, aMatcher.start());
            this.myHandledLink = aMatcher.group(2);
            this.myTextAfter = text2.substring(aMatcher.end());
        } else {
            this.myTextBefore = text2;
            this.myHandledLink = "";
            this.myTextAfter = "";
        }
        this.myLinkListener = listener2;
    }

    public void updateLinkText(@NotNull String text2) {
        this.myHandledLink = text2;
    }

    public void fireOnClick(@NotNull DefaultMutableTreeNode relatedNode, @NotNull MouseEvent event) {
        if (this.myLinkListener != null) {
            this.myLinkListener.hyperlinkActivated(relatedNode, event);
        }
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        boolean isActive = this.mySelected || this.myUnderlined;
        SimpleTextAttributes linkTextAttributes = isActive ? SimpleTextAttributes.LINK_ATTRIBUTES : SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
        isActive = isActive || !this.myTransparent;
        SimpleTextAttributes wrappedTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer, SimpleTextAttributes.REGULAR_ATTRIBUTES, isActive);
        if (!StringUtil.isEmptyOrSpaces((String)this.myTextBefore)) {
            renderer.append(this.myTextBefore, wrappedTextAttributes);
            renderer.append(" ");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myHandledLink)) {
            renderer.append(this.myHandledLink, PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer, linkTextAttributes, isActive), (Object)this);
        }
        renderer.append(this.myTextAfter, wrappedTextAttributes);
    }

    public void setUnderlined(boolean underlined) {
        this.myUnderlined = underlined;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    public void setTransparent(boolean transparent) {
        this.myTransparent = transparent;
    }

    @Override
    @NotNull
    public String getText() {
        return this.myTextBefore + this.myHandledLink + this.myTextAfter;
    }
}

