/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DvcsRememberedInputs {
    private State myState = new State();

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    public void addUrl(@NotNull String url) {
        this.addUrl(url, "");
    }

    public void addUrl(@NotNull String url, @NotNull String userName) {
        for (UrlAndUserName visitedUrl : this.myState.visitedUrls) {
            if (!visitedUrl.url.equalsIgnoreCase(url)) continue;
            if (!userName.isEmpty()) {
                visitedUrl.userName = userName;
            }
            return;
        }
        UrlAndUserName urlAndUserName = new UrlAndUserName();
        urlAndUserName.url = url;
        urlAndUserName.userName = userName;
        this.myState.visitedUrls.add(urlAndUserName);
    }

    @Nullable
    public String getUserNameForUrl(@NotNull String url) {
        for (UrlAndUserName urlAndUserName : this.myState.visitedUrls) {
            if (!urlAndUserName.url.equalsIgnoreCase(url)) continue;
            return urlAndUserName.userName;
        }
        return null;
    }

    @NotNull
    public List<String> getVisitedUrls() {
        ArrayList<String> urls = new ArrayList<String>(this.myState.visitedUrls.size());
        for (UrlAndUserName urlAndUserName : this.myState.visitedUrls) {
            urls.add(urlAndUserName.url);
        }
        return urls;
    }

    public String getCloneParentDir() {
        return this.myState.cloneParentDir;
    }

    public void setCloneParentDir(String cloneParentDir) {
        this.myState.cloneParentDir = cloneParentDir;
    }

    public void clear() {
        this.myState.visitedUrls.clear();
        this.myState.cloneParentDir = "";
    }

    public static class UrlAndUserName {
        public String url;
        public String userName;
    }

    public static class State {
        public List<UrlAndUserName> visitedUrls = new ArrayList<UrlAndUserName>();
        public String cloneParentDir = "";
    }
}

