/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.util.XmlStringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgIncomingCommand;
import org.zmlx.hg4idea.command.HgOutgoingCommand;
import org.zmlx.hg4idea.status.HgChangesetStatus;
import org.zmlx.hg4idea.status.ui.HgWidgetUpdater;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRemoteStatusUpdater
implements Disposable {
    private final Project myProject;
    private final HgVcs myVcs;
    private final HgChangesetStatus myIncomingStatus = new HgChangesetStatus(HgBundle.message("hg4idea.changesets.in", new Object[0]));
    private final HgChangesetStatus myOutgoingStatus = new HgChangesetStatus(HgBundle.message("hg4idea.changesets.out", new Object[0]));
    private final AtomicBoolean myUpdateStarted = new AtomicBoolean();

    public HgRemoteStatusUpdater(@NotNull HgVcs vcs) {
        this.myProject = vcs.getProject();
        this.myVcs = vcs;
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(HgVcs.REMOTE_TOPIC, (project, root) -> this.updateInBackground(root));
        busConnection.subscribe(HgVcs.INCOMING_OUTGOING_CHECK_TOPIC, (Object)new HgWidgetUpdater(){

            @Override
            public void updateVisibility() {
                HgRemoteStatusUpdater.this.updateInBackground(null);
            }
        });
        int checkIntervalSeconds = HgGlobalSettings.getIncomingCheckIntervalSeconds();
        ScheduledFuture<?> future = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.updateInBackground(null), 5L, checkIntervalSeconds, TimeUnit.SECONDS);
        Disposer.register((Disposable)this, () -> future.cancel(true));
    }

    public void dispose() {
    }

    public HgChangesetStatus getStatus(boolean isIncoming) {
        return isIncoming ? this.myIncomingStatus : this.myOutgoingStatus;
    }

    private void updateInBackground(final @Nullable VirtualFile root) {
        if (!HgRemoteStatusUpdater.isCheckingEnabled(this.myProject)) {
            return;
        }
        if (!this.myUpdateStarted.compareAndSet(false, true)) {
            return;
        }
        new Task.Backgroundable(this.myProject, HgRemoteStatusUpdater.getProgressTitle(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                VirtualFile[] virtualFileArray;
                if (this.myProject.isDisposed()) {
                    return;
                }
                if (root != null) {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = root;
                } else {
                    virtualFileArray = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)HgRemoteStatusUpdater.this.myVcs);
                }
                VirtualFile[] roots = virtualFileArray;
                HgRemoteStatusUpdater.updateChangesStatusSynchronously(this.myProject, roots, HgRemoteStatusUpdater.this.myIncomingStatus, true);
                HgRemoteStatusUpdater.updateChangesStatusSynchronously(this.myProject, roots, HgRemoteStatusUpdater.this.myOutgoingStatus, false);
                ((HgWidgetUpdater)BackgroundTaskUtil.syncPublisher((Project)this.myProject, HgVcs.INCOMING_OUTGOING_CHECK_TOPIC)).update();
            }

            public void onFinished() {
                HgRemoteStatusUpdater.this.myUpdateStarted.set(false);
            }
        }.queue();
    }

    private static void updateChangesStatusSynchronously(Project project, VirtualFile[] roots, HgChangesetStatus status, boolean incoming) {
        if (!HgRemoteStatusUpdater.isCheckingEnabled(project)) {
            return;
        }
        LinkedList<HgRevisionNumber> changesets = new LinkedList<HgRevisionNumber>();
        for (VirtualFile root : roots) {
            if (incoming) {
                changesets.addAll(new HgIncomingCommand(project).executeInCurrentThread(root));
                continue;
            }
            changesets.addAll(new HgOutgoingCommand(project).executeInCurrentThread(root));
        }
        status.setChanges(changesets.size(), new ChangesetFormatter(status, changesets));
    }

    private static String getProgressTitle() {
        return HgBundle.message("hg4idea.changesets.checking.progress", new Object[0]);
    }

    public static boolean isCheckingEnabled(@NotNull Project project) {
        HgVcs hgVcs = HgVcs.getInstance(project);
        if (hgVcs == null) {
            return false;
        }
        if (HgUtil.getRepositoryManager(project).getRepositories().isEmpty()) {
            return false;
        }
        return hgVcs.getProjectSettings().isCheckIncomingOutgoing();
    }

    private static final class ChangesetFormatter
    implements HgChangesetStatus.ChangesetWriter {
        private final String string;

        private ChangesetFormatter(HgChangesetStatus status, List<HgRevisionNumber> changesets) {
            StringBuilder builder = new StringBuilder();
            builder.append("<b>").append(status.getStatusName()).append(" changesets</b>:<br>");
            for (HgRevisionNumber revisionNumber : changesets) {
                builder.append(revisionNumber.asString()).append(" ").append(revisionNumber.getCommitMessage()).append(" (").append(revisionNumber.getAuthor()).append(")<br>");
            }
            this.string = XmlStringUtil.wrapInHtml((CharSequence)builder);
        }

        @Override
        public String asString() {
            return this.string;
        }
    }
}

