/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.provider.HgDiffFromHistoryHandler;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgHistoryProvider
implements VcsHistoryProvider {
    private final Project myProject;

    public HgHistoryProvider(Project project) {
        this.myProject = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])ColumnInfo.EMPTY_ARRAY);
    }

    public AnAction[] getAdditionalActions(Runnable runnable) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction")};
    }

    public boolean isDateOmittable() {
        return false;
    }

    public String getHelpId() {
        return null;
    }

    public VcsHistorySession createSessionFor(FilePath filePath) {
        ArrayList<VcsFileRevision> revisions;
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
        if (vcsRoot == null) {
            return null;
        }
        return this.createAppendableSession(vcsRoot, filePath, revisions, (revisions = new ArrayList<VcsFileRevision>(HgHistoryProvider.getHistory(filePath, vcsRoot, this.myProject))).isEmpty() ? null : ((VcsFileRevision)Objects.requireNonNull(ContainerUtil.getFirstItem(revisions))).getRevisionNumber());
    }

    public void reportAppendableHistory(FilePath filePath, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VirtualFile vcsRoot = HgUtil.getHgRootOrThrow(this.myProject, filePath);
        List<HgFileRevision> history = HgHistoryProvider.getHistory(filePath, vcsRoot, this.myProject);
        if (history.size() == 0) {
            return;
        }
        VcsAbstractHistorySession emptySession = this.createAppendableSession(vcsRoot, filePath, Collections.emptyList(), null);
        partner.reportCreatedEmptySession(emptySession);
        for (HgFileRevision hgFileRevision : history) {
            partner.acceptRevision((VcsFileRevision)hgFileRevision);
        }
    }

    @NotNull
    private VcsAbstractHistorySession createAppendableSession(final @NotNull VirtualFile vcsRoot, final @NotNull FilePath filePath, @NotNull List<VcsFileRevision> revisions, @Nullable VcsRevisionNumber number) {
        return new VcsAbstractHistorySession(revisions, number){

            @Nullable
            protected VcsRevisionNumber calcCurrentRevisionNumber() {
                if (filePath.isDirectory()) {
                    return new HgWorkingCopyRevisionsCommand(HgHistoryProvider.this.myProject).firstParent(vcsRoot);
                }
                return (VcsRevisionNumber)new HgWorkingCopyRevisionsCommand((Project)((HgHistoryProvider)HgHistoryProvider.this).myProject).parents((VirtualFile)vcsRoot, (FilePath)filePath).first;
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }

            public VcsHistorySession copy() {
                return HgHistoryProvider.this.createAppendableSession(vcsRoot, filePath, this.getRevisionList(), this.getCurrentRevisionNumber());
            }
        };
    }

    public static List<HgFileRevision> getHistory(@NotNull FilePath filePath, @NotNull VirtualFile vcsRoot, @NotNull Project project) {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        return HgHistoryProvider.getHistory(filePath, vcsRoot, project, null, vcsConfiguration.LIMIT_HISTORY ? vcsConfiguration.MAXIMUM_HISTORY_ROWS : -1);
    }

    public static List<HgFileRevision> getHistory(@NotNull FilePath filePath, @NotNull VirtualFile vcsRoot, @NotNull Project project, @Nullable HgRevisionNumber revisionNumber, int limit) {
        FilePath originalFilePath = HgUtil.getOriginalFileName(filePath, ChangeListManager.getInstance((Project)project));
        if (revisionNumber == null && !filePath.isDirectory() && !filePath.equals(originalFilePath)) {
            return HgHistoryProvider.getHistoryForUncommittedRenamed(originalFilePath, vcsRoot, project, limit);
        }
        HgLogCommand logCommand = new HgLogCommand(project);
        logCommand.setFollowCopies(!filePath.isDirectory());
        logCommand.setIncludeRemoved(true);
        ArrayList<String> args = new ArrayList<String>();
        if (revisionNumber != null) {
            args.add("--rev");
            args.add("reverse(0::" + revisionNumber.getChangeset() + ")");
        }
        return logCommand.execute(new HgFile(vcsRoot, filePath), limit, false, args);
    }

    private static List<HgFileRevision> getHistoryForUncommittedRenamed(@NotNull FilePath originalHgFilePath, @NotNull VirtualFile vcsRoot, @NotNull Project project, int limit) {
        HgFile originalHgFile = new HgFile(vcsRoot, originalHgFilePath);
        HgLogCommand logCommand = new HgLogCommand(project);
        logCommand.setIncludeRemoved(true);
        HgVersion version = logCommand.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(false, version);
        String template = HgChangesetUtil.makeTemplate(templates);
        ArrayList<String> argsForCmd = new ArrayList<String>();
        String relativePath = originalHgFile.getRelativePath();
        argsForCmd.add("--rev");
        argsForCmd.add(String.format("reverse(follow(%s))", relativePath != null ? "'" + FileUtil.toSystemIndependentName((String)relativePath) + "'" : ""));
        HgCommandResult result = logCommand.execute(vcsRoot, template, limit, relativePath != null ? null : originalHgFile, argsForCmd);
        return HgHistoryUtil.getCommitRecords(project, result, new HgFileRevisionLogParser(project, originalHgFile, version));
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new HgDiffFromHistoryHandler(this.myProject);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        return true;
    }
}

