/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SimpleRefGroup;
import com.intellij.vcs.log.impl.SimpleRefType;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.branch.HgBranchManager;
import org.zmlx.hg4idea.branch.HgBranchType;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgRefManager
implements VcsLogRefManager {
    private static final JBColor TIP_COLOR = JBColor.namedColor((String)"VersionControl.HgLog.tipIconColor", (Color)VcsLogStandardColors.Refs.TIP);
    private static final JBColor HEAD_COLOR = JBColor.namedColor((String)"VersionControl.HgLog.headIconColor", (Color)VcsLogStandardColors.Refs.LEAF);
    private static final JBColor BRANCH_COLOR = JBColor.namedColor((String)"VersionControl.HgLog.branchIconColor", (Color)VcsLogStandardColors.Refs.BRANCH);
    private static final JBColor CLOSED_BRANCH_COLOR = JBColor.namedColor((String)"VersionControl.HgLog.closedBranchIconColor", (Color)new JBColor(new Color(8532281), new Color(0xFF5F6F)));
    private static final JBColor BOOKMARK_COLOR = JBColor.namedColor((String)"VersionControl.HgLog.bookmarkIconColor", (Color)VcsLogStandardColors.Refs.BRANCH_REF);
    private static final JBColor TAG_COLOR = JBColor.namedColor((String)"VersionControl.HgLog.tagIconColor", (Color)VcsLogStandardColors.Refs.TAG);
    private static final JBColor LOCAL_TAG_COLOR = JBColor.namedColor((String)"VersionControl.HgLog.localTagIconColor", (Color)new JBColor(new Color(37008), new Color(62451)));
    private static final JBColor MQ_TAG_COLOR = JBColor.namedColor((String)"VersionControl.HgLog.mqTagIconColor", (Color)new JBColor(new Color(12176), new Color(22015)));
    public static final VcsRefType TIP = new SimpleRefType("TIP", true, (Color)TIP_COLOR);
    public static final VcsRefType HEAD = new SimpleRefType("HEAD", true, (Color)HEAD_COLOR);
    public static final VcsRefType BRANCH = new SimpleRefType("BRANCH", true, (Color)BRANCH_COLOR);
    public static final VcsRefType CLOSED_BRANCH = new SimpleRefType("CLOSED_BRANCH", false, (Color)CLOSED_BRANCH_COLOR);
    public static final VcsRefType BOOKMARK = new SimpleRefType("BOOKMARK", true, (Color)BOOKMARK_COLOR);
    public static final VcsRefType TAG = new SimpleRefType("TAG", false, (Color)TAG_COLOR);
    public static final VcsRefType LOCAL_TAG = new SimpleRefType("LOCAL_TAG", false, (Color)LOCAL_TAG_COLOR);
    public static final VcsRefType MQ_APPLIED_TAG = new SimpleRefType("MQ_TAG", false, (Color)MQ_TAG_COLOR);
    private static final List<VcsRefType> REF_TYPE_PRIORITIES = Arrays.asList(TIP, HEAD, BRANCH, BOOKMARK, TAG);
    private static final List<VcsRefType> REF_TYPE_INDEX = Arrays.asList(TIP, HEAD, BRANCH, CLOSED_BRANCH, BOOKMARK, TAG, LOCAL_TAG, MQ_APPLIED_TAG);
    public static final Comparator<VcsRefType> REF_TYPE_COMPARATOR = (type1, type2) -> {
        int p1 = REF_TYPE_PRIORITIES.indexOf(type1);
        int p2 = REF_TYPE_PRIORITIES.indexOf(type2);
        return p1 - p2;
    };
    public static final String DEFAULT = "default";
    private final Comparator<VcsRef> REF_COMPARATOR = (ref1, ref2) -> {
        VcsRefType type2;
        VcsRefType type1 = ref1.getType();
        int typeComparison = REF_TYPE_COMPARATOR.compare(type1, type2 = ref2.getType());
        if (typeComparison != 0) {
            return typeComparison;
        }
        int nameComparison = ref1.getName().compareTo(ref2.getName());
        if (nameComparison != 0) {
            if (type1 == BRANCH) {
                if (ref1.getName().equals(DEFAULT)) {
                    return -1;
                }
                if (ref2.getName().equals(DEFAULT)) {
                    return 1;
                }
            }
            return nameComparison;
        }
        return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
    };
    @NotNull
    private final HgBranchManager myBranchManager;
    @NotNull
    private final RepositoryManager<HgRepository> myRepositoryManager;

    public HgRefManager(@NotNull Project project, @NotNull RepositoryManager<HgRepository> repositoryManager) {
        this.myRepositoryManager = repositoryManager;
        this.myBranchManager = (HgBranchManager)((Object)ServiceManager.getService((Project)project, HgBranchManager.class));
    }

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        return this.REF_COMPARATOR;
    }

    @NotNull
    public List<RefGroup> groupForBranchFilter(@NotNull Collection<? extends VcsRef> refs) {
        List<VcsRef> sortedRefs = this.sort(refs);
        MultiMap groupedRefs = ContainerUtil.groupBy(sortedRefs, VcsRef::getType);
        ArrayList<RefGroup> result = new ArrayList<RefGroup>();
        ArrayList branches = new ArrayList();
        ArrayList bookmarks = new ArrayList();
        for (Map.Entry entry : groupedRefs.entrySet()) {
            if (((VcsRefType)entry.getKey()).equals(TIP) || ((VcsRefType)entry.getKey()).equals(HEAD)) {
                for (VcsRef ref : (Collection)entry.getValue()) {
                    result.add((RefGroup)new SingletonRefGroup(ref));
                }
                continue;
            }
            if (((VcsRefType)entry.getKey()).equals(BOOKMARK)) {
                bookmarks.addAll((Collection)entry.getValue());
                continue;
            }
            branches.addAll((Collection)entry.getValue());
        }
        if (!branches.isEmpty()) {
            result.add((RefGroup)new SimpleRefGroup("Branches", branches, false));
        }
        if (!bookmarks.isEmpty()) {
            result.add((RefGroup)new SimpleRefGroup("Bookmarks", bookmarks, false));
        }
        return result;
    }

    @NotNull
    public List<RefGroup> groupForTable(@NotNull Collection<? extends VcsRef> references, boolean compact, boolean showTagNames) {
        List<VcsRef> sortedReferences = this.sort(references);
        ArrayList<VcsRef> headAndTip = new ArrayList<VcsRef>();
        MultiMap groupedRefs = MultiMap.createLinked();
        for (VcsRef ref : sortedReferences) {
            if (ref.getType().equals(HEAD) || ref.getType().equals(TIP)) {
                headAndTip.add(ref);
                continue;
            }
            groupedRefs.putValue((Object)ref.getType(), (Object)ref);
        }
        ArrayList<RefGroup> result = new ArrayList<RefGroup>();
        SimpleRefGroup.buildGroups((MultiMap)groupedRefs, (boolean)compact, (boolean)showTagNames, result);
        RefGroup firstGroup = (RefGroup)ContainerUtil.getFirstItem(result);
        if (firstGroup != null) {
            firstGroup.getRefs().addAll(0, headAndTip);
        } else {
            result.add((RefGroup)new SimpleRefGroup("", headAndTip));
        }
        return result;
    }

    public void serialize(@NotNull DataOutput out, @NotNull VcsRefType type) throws IOException {
        out.writeInt(REF_TYPE_INDEX.indexOf(type));
    }

    @NotNull
    public VcsRefType deserialize(@NotNull DataInput in) throws IOException {
        int id = in.readInt();
        if (id < 0 || id > REF_TYPE_INDEX.size() - 1) {
            throw new IOException("Reference type by id " + id + " does not exist");
        }
        return REF_TYPE_INDEX.get(id);
    }

    @NotNull
    private static HgBranchType getBranchType(@NotNull VcsRef reference) {
        return reference.getType().equals(BOOKMARK) ? HgBranchType.BOOKMARK : HgBranchType.BRANCH;
    }

    @Nullable
    private HgRepository getRepository(@NotNull VcsRef reference) {
        return (HgRepository)this.myRepositoryManager.getRepositoryForRootQuick(reference.getRoot());
    }

    public boolean isFavorite(@NotNull VcsRef reference) {
        if (reference.getType().equals(HEAD) || reference.getType().equals(TIP)) {
            return true;
        }
        if (!reference.getType().isBranch()) {
            return false;
        }
        return this.myBranchManager.isFavorite(HgRefManager.getBranchType(reference), this.getRepository(reference), reference.getName());
    }

    public void setFavorite(@NotNull VcsRef reference, boolean favorite) {
        if (!reference.getType().isBranch() || reference.getType().equals(HEAD) || reference.getType().equals(TIP)) {
            return;
        }
        this.myBranchManager.setFavorite(HgRefManager.getBranchType(reference), this.getRepository(reference), reference.getName(), favorite);
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        return this.REF_COMPARATOR;
    }

    @NotNull
    private List<VcsRef> sort(@NotNull Collection<? extends VcsRef> refs) {
        return ContainerUtil.sorted(refs, this.getLabelsOrderComparator());
    }
}

