/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BinaryOSProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.LineHandlerHelper;
import com.intellij.vcs.VcsLocaleHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgLineProcessListener;
import org.zmlx.hg4idea.execution.ShellCommandException;

public final class ShellCommand {
    private final GeneralCommandLine myCommandLine;

    public ShellCommand(@NotNull List<String> commandLine, @Nullable String dir, @Nullable Charset charset) {
        if (commandLine.isEmpty()) {
            throw new IllegalArgumentException("commandLine is empty");
        }
        this.myCommandLine = new GeneralCommandLine(commandLine);
        if (dir != null) {
            this.myCommandLine.setWorkDirectory(new File(dir));
        }
        if (charset != null) {
            this.myCommandLine.setCharset(charset);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCommandLine.getEnvironment().put("HGRCPATH", "");
        }
        this.myCommandLine.withEnvironment(VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"hg"));
    }

    @NotNull
    public HgCommandResult execute(boolean showTextOnIndicator, boolean isBinary) throws ShellCommandException {
        CommandResultCollector listener = new CommandResultCollector(isBinary);
        this.execute(showTextOnIndicator, isBinary, listener);
        return listener.getResult();
    }

    public void execute(final boolean showTextOnIndicator, boolean isBinary, final @NotNull HgLineProcessListener listener) throws ShellCommandException {
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            BinaryOSProcessHandler processHandler = isBinary ? new BinaryOSProcessHandler(this.myCommandLine) : new KillableProcessHandler(this.myCommandLine, Registry.is((String)"hg4idea.execute.with.mediator"));
            ProcessAdapter outputAdapter = new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    for (String line : LineHandlerHelper.splitText((String)event.getText())) {
                        if (ProcessOutputTypes.STDOUT == outputType && indicator != null && showTextOnIndicator) {
                            indicator.setText2(line);
                        }
                        listener.onLineAvailable(line, outputType);
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    listener.setExitCode(event.getExitCode());
                }
            };
            processHandler.addProcessListener((ProcessListener)outputAdapter);
            processHandler.startNotify();
            while (!processHandler.waitFor(300L)) {
                if (indicator == null || !indicator.isCanceled()) continue;
                processHandler.destroyProcess();
                listener.setExitCode(255);
                break;
            }
            if (isBinary) {
                listener.setBinaryOutput(processHandler.getOutput());
            }
        }
        catch (ExecutionException e) {
            throw new ShellCommandException(e);
        }
    }

    public static class CommandResultCollector
    extends HgLineProcessListener {
        @NotNull
        private final ProcessOutput myOutput;
        private final boolean myIsBinary;

        public CommandResultCollector(boolean binary) {
            this.myIsBinary = binary;
            this.myOutput = new ProcessOutput();
        }

        @Override
        protected void processOutputLine(@NotNull String line) {
            this.myOutput.appendStdout(line);
        }

        @Override
        protected void processErrorLine(@NotNull String line) {
            super.processErrorLine(line);
            this.myOutput.appendStderr(line);
        }

        @Override
        public void setExitCode(int exitCode) {
            super.setExitCode(exitCode);
            this.myOutput.setExitCode(exitCode);
        }

        public HgCommandResult getResult() {
            return this.myIsBinary ? new HgCommandResult(this.myOutput, this.getBinaryOutput()) : new HgCommandResult(this.myOutput);
        }
    }
}

