/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQPopCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQPopCommand(@NotNull HgRepository repository) {
        this.myRepository = repository;
    }

    public HgCommandResult executeInCurrentThread() {
        Project project = this.myRepository.getProject();
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(this.myRepository.getRoot(), "qpop", Collections.singletonList("--all"));
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError(result, HgBundle.message("action.hg4idea.QPop.error", new Object[0]), HgBundle.message("action.hg4idea.QPop.error.msg", new Object[0]));
        } else {
            assert (result != null);
            if (!result.getErrorLines().isEmpty()) {
                VcsNotifier.getInstance((Project)project).notifyWarning(HgBundle.message("action.hg4idea.QPop.error.warning", new Object[0]), result.getRawError());
            }
        }
        this.myRepository.update();
        return result;
    }
}

