/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchUtil {
    @NotNull
    public static List<String> getCommonBranches(@NotNull Collection<? extends HgRepository> repositories) {
        return HgBranchUtil.getCommonNames(repositories, false);
    }

    @NotNull
    public static List<String> getCommonBookmarks(@NotNull Collection<? extends HgRepository> repositories) {
        return HgBranchUtil.getCommonNames(repositories, true);
    }

    private static List<String> getCommonNames(@NotNull Collection<? extends HgRepository> repositories, boolean bookmarkType) {
        Collection<String> common = null;
        for (HgRepository hgRepository : repositories) {
            Collection<String> names = bookmarkType ? HgUtil.getSortedNamesWithoutHashes(hgRepository.getBookmarks()) : hgRepository.getOpenedBranches();
            common = common == null ? names : ContainerUtil.intersection(common, names);
        }
        return common != null ? ((StreamEx)StreamEx.of(common).sorted(StringUtil::naturalCompare)).toList() : Collections.emptyList();
    }
}

