/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.action.HgProcessStateAction;
import org.zmlx.hg4idea.command.HgGraftCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgContinueGraftAction
extends HgProcessStateAction {
    public HgContinueGraftAction() {
        super(Repository.State.GRAFTING);
    }

    @Override
    protected void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repositories, final @Nullable HgRepository selectedRepo) {
        new Task.Backgroundable(project, HgBundle.message("action.hg4idea.Graft.Continue.progress", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (selectedRepo != null) {
                    HgGraftCommand graftCommand = new HgGraftCommand(project, selectedRepo);
                    HgCommandResult result = graftCommand.continueGrafting();
                    if (HgErrorUtil.isAbort(result)) {
                        new HgCommandResultNotifier(project).notifyError(result, HgBundle.message("hg4idea.hg.error", new Object[0]), HgBundle.message("action.hg4idea.Graft.continue.error", new Object[0]));
                    }
                    HgUtil.markDirectoryDirty(project, selectedRepo.getRoot());
                }
            }
        }.queue();
    }
}

