/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.annotations.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.status.ui.HgWidgetUpdater;

@com.intellij.openapi.components.State(name="hg4idea.settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class HgProjectSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings,
DvcsCompareSettings {
    @NotNull
    private final Project myProject;
    private State myState = new State();

    public HgProjectSettings(@NotNull Project project) {
        this.myProject = project;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        if (state.CHECK_INCOMING_OUTGOING == null) {
            state.CHECK_INCOMING_OUTGOING = state.myCheckIncoming || state.myCheckOutgoing;
        }
    }

    public static HgProjectSettings getInstance(@NotNull Project project) {
        return (HgProjectSettings)ServiceManager.getService((Project)project, HgProjectSettings.class);
    }

    @Nullable
    public String getHgExecutable() {
        return this.myState.PATH_TO_EXECUTABLE;
    }

    public void setHgExecutable(@Nullable String path) {
        this.myState.PATH_TO_EXECUTABLE = path;
    }

    public boolean isHgExecutableOverridden() {
        return this.myState.OVERRIDE_APPLICATION_PATH_TO_EXECUTABLE;
    }

    public void setHgExecutableOverridden(boolean overridden) {
        this.myState.OVERRIDE_APPLICATION_PATH_TO_EXECUTABLE = overridden;
    }

    @Nullable
    public String getRecentRootPath() {
        return this.myState.RECENT_HG_ROOT_PATH;
    }

    public void setRecentRootPath(@NotNull String recentRootPath) {
        this.myState.RECENT_HG_ROOT_PATH = recentRootPath;
    }

    public boolean isCheckIncomingOutgoing() {
        if (this.myState.CHECK_INCOMING_OUTGOING == null) {
            return this.myState.myCheckIncoming || this.myState.myCheckOutgoing;
        }
        return this.myState.CHECK_INCOMING_OUTGOING;
    }

    public void setCheckIncomingOutgoing(boolean checkIncomingOutgoing) {
        Boolean oldValue = this.myState.CHECK_INCOMING_OUTGOING;
        if (oldValue == null || oldValue != checkIncomingOutgoing) {
            this.myState.CHECK_INCOMING_OUTGOING = checkIncomingOutgoing;
            ((HgWidgetUpdater)BackgroundTaskUtil.syncPublisher((Project)this.myProject, HgVcs.INCOMING_OUTGOING_CHECK_TOPIC)).updateVisibility();
        }
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        return this.myState.ROOT_SYNC;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value syncSetting) {
        this.myState.ROOT_SYNC = syncSetting;
    }

    public boolean shouldSwapSidesInCompareBranches() {
        return this.myState.SWAP_SIDES_IN_COMPARE_BRANCHES;
    }

    public void setSwapSidesInCompareBranches(boolean value) {
        this.myState.SWAP_SIDES_IN_COMPARE_BRANCHES = value;
    }

    public boolean isWhitespacesIgnoredInAnnotations() {
        return this.myState.myIgnoreWhitespacesInAnnotations;
    }

    public void setIgnoreWhitespacesInAnnotations(boolean ignoreWhitespacesInAnnotations) {
        if (this.myState.myIgnoreWhitespacesInAnnotations != ignoreWhitespacesInAnnotations) {
            this.myState.myIgnoreWhitespacesInAnnotations = ignoreWhitespacesInAnnotations;
            ((VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).configurationChanged(HgVcs.getKey());
        }
    }

    @NotNull
    public DvcsBranchSettings getBranchSettings() {
        return this.myState.BRANCH_SETTINGS;
    }

    public static class State {
        public String PATH_TO_EXECUTABLE = null;
        public boolean OVERRIDE_APPLICATION_PATH_TO_EXECUTABLE = false;
        public boolean myCheckIncoming = true;
        public boolean myCheckOutgoing = true;
        public Boolean CHECK_INCOMING_OUTGOING = null;
        public boolean myIgnoreWhitespacesInAnnotations = true;
        public String RECENT_HG_ROOT_PATH = null;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
        public boolean SWAP_SIDES_IN_COMPARE_BRANCHES = false;
        @Property(surroundWithTag=false, flat=true)
        public DvcsBranchSettings BRANCH_SETTINGS = new DvcsBranchSettings();
    }
}

