/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Base64;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.io.NettyKt;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.Attribute;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.DelegatingHttpRequestHandlerBase;
import org.jetbrains.io.DelegatingHttpRequestHandlerKt;
import org.jetbrains.io.Responses;

@ChannelHandler.Sharable
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/io/DelegatingHttpRequestHandler;", "Lorg/jetbrains/io/DelegatingHttpRequestHandlerBase;", "()V", "authenticateAndUpdateUrlIfNeeded", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "authenticateOnUrlAndUpdateUrl", "expectedToken", "", "exceptionCaught", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "cause", "", "getTokenFromAuthorization", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "intellij.platform.ide.util.io"})
public final class DelegatingHttpRequestHandler
extends DelegatingHttpRequestHandlerBase {
    @Override
    protected boolean process(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        HttpRequestHandler connectedHandler;
        Function2<HttpRequestHandler, QueryStringDecoder, Boolean> $fun$checkAndProcess$1 = new Function2<HttpRequestHandler, QueryStringDecoder, Boolean>(request, context){
            final /* synthetic */ FullHttpRequest $request;
            final /* synthetic */ ChannelHandlerContext $context;

            public final boolean invoke(@NotNull HttpRequestHandler $this$checkAndProcess, @NotNull QueryStringDecoder urlDecoder) {
                return $this$checkAndProcess.isSupported(this.$request) && !NettyKt.isWriteFromBrowserWithoutOrigin((HttpRequest)this.$request) && $this$checkAndProcess.isAccessible((HttpRequest)this.$request) && $this$checkAndProcess.process(urlDecoder, this.$request, this.$context);
            }
            {
                this.$request = fullHttpRequest;
                this.$context = channelHandlerContext;
                super(2);
            }
        };
        if (!this.authenticateAndUpdateUrlIfNeeded(request)) {
            String product = ApplicationInfo.getInstance().getVersionName();
            Responses.sendUnauthorizedAuthenticate(context, (HttpRequest)request, product);
            return true;
        }
        QueryStringDecoder updatedUrlDecoder = new QueryStringDecoder(request.uri());
        Attribute prevHandlerAttribute = context.channel().attr(DelegatingHttpRequestHandlerKt.access$getPREV_HANDLER$p());
        WeakReference weakReference = (WeakReference)prevHandlerAttribute.get();
        HttpRequestHandler httpRequestHandler = connectedHandler = weakReference != null ? (HttpRequestHandler)weakReference.get() : null;
        if (connectedHandler != null) {
            if ($fun$checkAndProcess$1.invoke(connectedHandler, updatedUrlDecoder)) {
                return true;
            }
            prevHandlerAttribute.set(null);
        }
        return HttpRequestHandler.Companion.getEP_NAME().findFirstSafe((Predicate)new Predicate<HttpRequestHandler>($fun$checkAndProcess$1, updatedUrlDecoder, prevHandlerAttribute){
            final /* synthetic */ process.1 $checkAndProcess$1;
            final /* synthetic */ QueryStringDecoder $updatedUrlDecoder;
            final /* synthetic */ Attribute $prevHandlerAttribute;

            public final boolean test(HttpRequestHandler handler2) {
                boolean bl;
                if (this.$checkAndProcess$1.invoke(handler2, this.$updatedUrlDecoder)) {
                    this.$prevHandlerAttribute.set(new WeakReference<HttpRequestHandler>(handler2));
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.$checkAndProcess$1 = var1_1;
                this.$updatedUrlDecoder = queryStringDecoder;
                this.$prevHandlerAttribute = attribute;
            }
        }) != null;
    }

    private final boolean authenticateAndUpdateUrlIfNeeded(FullHttpRequest request) {
        if (Intrinsics.areEqual((Object)request.uri(), (Object)"/favicon.ico")) {
            return true;
        }
        String expectedToken = null;
        try {
            expectedToken = BuiltinWebServerAccess.getUserAuthenticationToken();
        }
        catch (IOException e) {
            DelegatingHttpRequestHandlerKt.access$getLOG$p().error("Unable to read user authentication token", (Throwable)e);
            return false;
        }
        String receivedToken = this.getTokenFromAuthorization(request);
        if (receivedToken != null) {
            return Intrinsics.areEqual((Object)expectedToken, (Object)receivedToken);
        }
        return this.authenticateOnUrlAndUpdateUrl(request, expectedToken);
    }

    private final boolean authenticateOnUrlAndUpdateUrl(FullHttpRequest request, String expectedToken) {
        String prefix;
        String uri = request.uri();
        if (StringsKt.startsWith$default((String)uri, (String)(prefix = '/' + expectedToken + '/'), (boolean)false, (int)2, null)) {
            String string = uri;
            int n = prefix.length() - 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            request.setUri(string3);
            return true;
        }
        return false;
    }

    private final String getTokenFromAuthorization(FullHttpRequest request) {
        String authorization = request.headers().get("Authorization");
        CharSequence charSequence = authorization;
        boolean bl = false;
        int n = 0;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        if (!StringsKt.startsWith$default((String)authorization, (String)"Basic ", (boolean)false, (int)2, null) || authorization.length() < 7) {
            Logger logger = DelegatingHttpRequestHandlerKt.access$getLOG$p();
            charSequence = StringCompanionObject.INSTANCE;
            String string = "Invalid authorization header '%s', unexpected type.";
            Object[] objectArray = new Object[]{authorization};
            boolean bl2 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            logger.warn(string2);
            return null;
        }
        String string = authorization;
        n = 6;
        boolean bl3 = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String base64 = string4;
        String decoded = null;
        try {
            byte[] byArray = Base64.decode((String)base64);
            bl3 = false;
            decoded = new String(byArray, Charsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            Logger logger = DelegatingHttpRequestHandlerKt.access$getLOG$p();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string5 = "Invalid authorization header '%s', bad base64 encoding.";
            Object[] objectArray = new Object[]{authorization};
            boolean bl4 = false;
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
            logger.warn(string6);
            return null;
        }
        List parts = StringsKt.split$default((CharSequence)decoded, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 2) {
            Logger logger = DelegatingHttpRequestHandlerKt.access$getLOG$p();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string7 = "Invalid authorization header '%s', bad username/password pair.";
            Object[] objectArray = new Object[]{authorization};
            boolean bl5 = false;
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"java.lang.String.format(format, *args)");
            logger.warn(string8);
            return null;
        }
        String username = (String)parts.get(0);
        String password = (String)parts.get(1);
        if (Intrinsics.areEqual((Object)"_token_", (Object)username) ^ true) {
            Logger logger = DelegatingHttpRequestHandlerKt.access$getLOG$p();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string9 = "Invalid authorization header '%s'";
            Object[] objectArray = new Object[]{authorization};
            boolean bl6 = false;
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"java.lang.String.format(format, *args)");
            logger.warn(string10);
            return null;
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        try {
            context.channel().attr(DelegatingHttpRequestHandlerKt.access$getPREV_HANDLER$p()).set(null);
        }
        finally {
            super.exceptionCaught(context, cause);
        }
    }
}

