/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutput {
    private final StringBuilder myStdoutBuilder = new StringBuilder();
    private final StringBuilder myStderrBuilder = new StringBuilder();
    @Nullable
    private Integer myExitCode;
    private boolean myTimeout;
    private boolean myCancelled;

    public ProcessOutput() {
    }

    public ProcessOutput(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void appendStdout(@Nullable String text) {
        this.myStdoutBuilder.append(text);
    }

    public void appendStderr(@Nullable String text) {
        this.myStderrBuilder.append(text);
    }

    @NotNull
    public String getStdout() {
        return this.myStdoutBuilder.toString();
    }

    @NotNull
    public String getStderr() {
        return this.myStderrBuilder.toString();
    }

    @NotNull
    public List<String> getStdoutLines() {
        return this.getStdoutLines(true);
    }

    @NotNull
    public List<String> getStdoutLines(boolean excludeEmptyLines) {
        return ProcessOutput.splitLines(this.getStdout(), excludeEmptyLines);
    }

    @NotNull
    public List<String> getStderrLines() {
        return this.getStderrLines(true);
    }

    @NotNull
    public List<String> getStderrLines(boolean excludeEmptyLines) {
        return ProcessOutput.splitLines(this.getStderr(), excludeEmptyLines);
    }

    private static List<String> splitLines(String s, boolean excludeEmptyLines) {
        String converted = StringUtil.convertLineSeparators((String)s);
        return StringUtil.split((String)converted, (String)"\n", (boolean)true, (boolean)excludeEmptyLines);
    }

    public boolean checkSuccess(@NotNull Logger logger) {
        int ec = this.getExitCode();
        if (ec == 0 && !this.isTimeout()) {
            return true;
        }
        logger.info(this.isTimeout() ? "Timed out" : "Exit code " + ec);
        String output = this.getStderr();
        if (output.isEmpty()) {
            output = this.getStdout();
        }
        if (!output.isEmpty()) {
            logger.info(output);
        }
        return false;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public int getExitCode() {
        Integer code = this.myExitCode;
        return code == null ? -1 : code;
    }

    public boolean isExitCodeSet() {
        return this.myExitCode != null;
    }

    public void setTimeout() {
        this.myTimeout = true;
    }

    public boolean isTimeout() {
        return this.myTimeout;
    }

    public void setCancelled() {
        this.myCancelled = true;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }
}

