/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.diagnostic.LoadingState;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance(OSProcessHandler.class);
    private static final Set<String> REPORTED_EXECUTIONS = ContainerUtil.newConcurrentSet();
    private static final long ALLOWED_TIMEOUT_THRESHOLD = 10L;
    private static final Key<Set<File>> DELETE_FILES_ON_TERMINATION = Key.create((String)"OSProcessHandler.FileToDelete");
    private final boolean myHasErrorStream;
    @NotNull
    private final ModalityState myModality;
    private boolean myHasPty;
    private boolean myDestroyRecursively = true;
    private final Set<? extends File> myFilesToDelete;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(OSProcessHandler.startProcess(commandLine), commandLine.getCommandLineString(), commandLine.getCharset());
        LoadingState.CONFIGURATION_STORE_INITIALIZED.checkOccurred();
        this.setHasPty(OSProcessHandler.isPtyProcess(this.getProcess()));
        this.myHasErrorStream = !commandLine.isRedirectErrorStream();
        this.myFilesToDelete = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
        this.myModality = OSProcessHandler.getDefaultModality();
    }

    @NotNull
    public static ModalityState getDefaultModality() {
        Application app = ApplicationManager.getApplication();
        return app == null ? ModalityState.NON_MODAL : app.getDefaultModalityState();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public OSProcessHandler(@NotNull Process process2) {
        this(process2, null);
        DeprecatedMethodException.report((String)"Use OSProcessHandler(Process, String) instead");
    }

    public OSProcessHandler(@NotNull Process process2, String commandLine) {
        this(process2, commandLine, EncodingManager.getInstance().getDefaultConsoleEncoding());
    }

    public OSProcessHandler(@NotNull Process process2, String commandLine, @Nullable Charset charset) {
        this(process2, commandLine, charset, null);
    }

    public OSProcessHandler(@NotNull Process process2, String commandLine, @Nullable Charset charset, @Nullable Set<? extends File> filesToDelete) {
        super(process2, commandLine, charset);
        this.setHasPty(OSProcessHandler.isPtyProcess(process2));
        this.myFilesToDelete = filesToDelete;
        this.myHasErrorStream = true;
        this.myModality = OSProcessHandler.getDefaultModality();
    }

    @NotNull
    private static Process startProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        try {
            return commandLine.createProcess();
        }
        catch (Throwable e) {
            OSProcessHandler.deleteTempFiles(commandLine.getUserData(DELETE_FILES_ON_TERMINATION));
            throw e;
        }
    }

    public boolean waitFor() {
        OSProcessHandler.checkEdtAndReadAction((ProcessHandler)this);
        return super.waitFor();
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        if (timeoutInMilliseconds > 10L) {
            OSProcessHandler.checkEdtAndReadAction((ProcessHandler)this);
        }
        return super.waitFor(timeoutInMilliseconds);
    }

    public static void checkEdtAndReadAction(@NotNull ProcessHandler processHandler) {
        Application application = ApplicationManager.getApplication();
        if (application == null || !application.isInternal() || application.isHeadlessEnvironment()) {
            return;
        }
        String message = null;
        if (application.isDispatchThread()) {
            message = "Synchronous execution on EDT: ";
        } else if (application.isReadAccessAllowed()) {
            message = "Synchronous execution under ReadAction: ";
        }
        if (message != null && REPORTED_EXECUTIONS.add(ExceptionUtil.currentStackTrace())) {
            LOG.error(message + processHandler + ", see com.intellij.execution.process.OSProcessHandler#checkEdtAndReadAction() Javadoc for resolutions");
        }
    }

    private static void deleteTempFiles(Set<? extends File> tempFiles) {
        if (tempFiles != null) {
            try {
                for (File file : tempFiles) {
                    FileUtil.delete((File)file);
                }
            }
            catch (Throwable t) {
                LOG.error("failed to delete temp. files", t);
            }
        }
    }

    private static boolean isPtyProcess(Process process2) {
        for (Class<?> c = process2.getClass(); c != null; c = c.getSuperclass()) {
            if (!"com.pty4j.unix.UnixPtyProcess".equals(c.getName()) && !"com.pty4j.windows.WinPtyProcess".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    protected void onOSProcessTerminated(int exitCode) {
        if (this.myModality != ModalityState.NON_MODAL) {
            ProgressManager.getInstance().runProcess(() -> super.onOSProcessTerminated(exitCode), (ProgressIndicator)new EmptyProgressIndicator(this.myModality));
        } else {
            super.onOSProcessTerminated(exitCode);
        }
        OSProcessHandler.deleteTempFiles(this.myFilesToDelete);
    }

    protected boolean processHasSeparateErrorStream() {
        return this.myHasErrorStream;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    protected void doDestroyProcess() {
        Process process2 = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process2)) {
            this.killProcessTree(process2);
        } else {
            process2.destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process2) {
        return !(process2 instanceof SelfKiller);
    }

    protected void killProcessTree(@NotNull Process process2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.killProcessTreeSync(process2);
        } else {
            this.executeTask(() -> this.killProcessTreeSync(process2));
        }
    }

    private void killProcessTreeSync(@NotNull Process process2) {
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessUtil.killProcessTree(process2);
        if (!destroyed) {
            if (!process2.isAlive()) {
                LOG.warn("Process has been already terminated: " + this.myCommandLine);
            } else {
                LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.myCommandLine);
                process2.destroy();
            }
        }
    }

    public void setHasPty(boolean hasPty) {
        this.myHasPty = hasPty;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        return this.myHasPty ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
    }

    public static void deleteFileOnTermination(@NotNull GeneralCommandLine commandLine, @NotNull File fileToDelete) {
        Set<File> set = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
        if (set == null) {
            set = new HashSet<File>();
            commandLine.putUserData(DELETE_FILES_ON_TERMINATION, set);
        }
        set.add(fileToDelete);
    }

    public static class Silent
    extends OSProcessHandler {
        public Silent(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            super(commandLine);
        }

        @Override
        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return BaseOutputReader.Options.forMostlySilentProcess();
        }
    }
}

